/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.plugins.BuildConfigurationRule;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.plugins.internal.DefaultBasePluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

public abstract class BasePlugin
implements Plugin<Project> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String BUILD_GROUP = "build";

    public void apply(Project project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        BasePluginExtension baseExtension = (BasePluginExtension)project.getExtensions().create(BasePluginExtension.class, "base", DefaultBasePluginExtension.class, new Object[]{project});
        this.configureExtension(project, baseExtension);
        this.configureBuildConfigurationRule(project);
        this.configureArchiveDefaults(project, baseExtension);
        this.configureConfigurations(project);
    }

    private void configureExtension(Project project, BasePluginExtension extension) {
        extension.getArchivesName().convention((Object)project.getName());
        extension.getLibsDirectory().convention(project.getLayout().getBuildDirectory().dir("libs"));
        extension.getDistsDirectory().convention(project.getLayout().getBuildDirectory().dir("distributions"));
    }

    private void configureArchiveDefaults(Project project, BasePluginExtension extension) {
        project.getTasks().withType(AbstractArchiveTask.class).configureEach(task -> {
            task.getDestinationDirectory().convention((Provider)extension.getDistsDirectory());
            task.getArchiveVersion().convention(project.provider(() -> project.getVersion() == "unspecified" ? null : project.getVersion().toString()));
            task.getArchiveBaseName().convention(extension.getArchivesName());
        });
    }

    private void configureBuildConfigurationRule(Project project) {
        project.getTasks().addRule((Rule)new BuildConfigurationRule(project.getConfigurations(), project.getTasks()));
    }

    private void configureConfigurations(Project project) {
        RoleBasedConfigurationContainerInternal configurations = (RoleBasedConfigurationContainerInternal)project.getConfigurations();
        ((ProjectInternal)project).getInternalStatus().convention((Object)"integration");
        Configuration archivesConfiguration = configurations.maybeCreateConsumableUnlocked("archives").setDescription("Configuration for archive artifacts.");
        configurations.maybeCreateConsumableUnlocked("default").setDescription("Configuration for default artifacts.");
        project.getTasks().named(ASSEMBLE_TASK_NAME, task -> task.dependsOn(new Object[]{archivesConfiguration.getAllArtifacts().getBuildDependencies()}));
    }
}

