/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.io.IOException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.jspecify.annotations.Nullable;

public class JavaExecutableUtils {
    public static File resolveExecutable(String executable) {
        File executableAbsoluteFile;
        File executableFile = new File(executable);
        if (!executableFile.isAbsolute()) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Configuring a Java executable via a relative path.").withContext("Resolving relative file paths might yield unexpected results, there is no single clear location it would make sense to resolve against.")).withAdvice("Configure an absolute path to a Java executable instead.")).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "no_relative_paths_for_java_executables")).nagUser();
        }
        if (!(executableAbsoluteFile = executableFile.getAbsoluteFile()).exists()) {
            throw new InvalidUserDataException("The configured executable does not exist (" + executableFile.getAbsolutePath() + ")");
        }
        if (executableAbsoluteFile.isDirectory()) {
            throw new InvalidUserDataException("The configured executable is a directory (" + executableFile.getAbsolutePath() + ")");
        }
        return executableAbsoluteFile;
    }

    public static File resolveJavaHomeOfExecutable(String executable) {
        return JavaExecutableUtils.resolveExecutable(executable).getParentFile().getParentFile();
    }

    public static void validateExecutable(@Nullable String executable, String executableDescription, File referenceFile, String referenceDescription) {
        if (executable == null) {
            return;
        }
        File executableFile = JavaExecutableUtils.resolveExecutable(executable);
        JavaExecutableUtils.validateMatchingFiles(executableFile, executableDescription, referenceFile, referenceDescription);
    }

    public static void validateMatchingFiles(File customFile, String customDescription, File referenceFile, String referenceDescription) {
        File canonicalReferenceFile;
        if (customFile.equals(referenceFile)) {
            return;
        }
        File canonicalCustomFile = JavaExecutableUtils.canonicalFile(customFile);
        if (canonicalCustomFile.equals(canonicalReferenceFile = JavaExecutableUtils.canonicalFile(referenceFile))) {
            return;
        }
        throw new IllegalStateException(customDescription + " does not match " + referenceDescription + ".");
    }

    private static File canonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't resolve canonical path of file " + file, e);
        }
    }
}

