/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.tasks;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.repositories.DefaultIvyArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.layout.AbstractRepositoryLayout;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyDuplicatePublicationTracker;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublisher;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.authentication.Authentication;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.serialization.Transient;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.Nullable;

@DisableCachingByDefault(because="Not worth caching")
public abstract class PublishToIvyRepository
extends DefaultTask {
    private final Transient.Var<IvyPublicationInternal> publication = Transient.varOf();
    private final Transient.Var<DefaultIvyArtifactRepository> repository = Transient.varOf();
    private final Cached<PublishSpec> spec = Cached.of(this::computeSpec);
    private final Property<Credentials> credentials = this.getProject().getObjects().property(Credentials.class);

    public PublishToIvyRepository() {
        this.getInputs().files(new Object[]{() -> {
            IvyPublicationInternal publicationInternal = this.getPublicationInternal();
            return publicationInternal == null ? null : publicationInternal.getPublishableArtifacts().getFiles();
        }}).withPropertyName("publication.publishableFiles").withPathSensitivity(PathSensitivity.NAME_ONLY);
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public IvyPublication getPublication() {
        return (IvyPublication)this.publication.get();
    }

    public void setPublication(IvyPublication publication) {
        this.publication.set((Object)PublishToIvyRepository.toPublicationInternal(publication));
    }

    private IvyPublicationInternal getPublicationInternal() {
        return PublishToIvyRepository.toPublicationInternal(this.getPublication());
    }

    private static IvyPublicationInternal toPublicationInternal(IvyPublication publication) {
        if (publication == null) {
            return null;
        }
        if (publication instanceof IvyPublicationInternal) {
            return (IvyPublicationInternal)publication;
        }
        throw new InvalidUserDataException(String.format("publication objects must implement the '%s' interface, implementation '%s' does not", IvyPublicationInternal.class.getName(), publication.getClass().getName()));
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public IvyArtifactRepository getRepository() {
        return (IvyArtifactRepository)this.repository.get();
    }

    @Nested
    @Optional
    Property<Credentials> getCredentials() {
        return this.credentials;
    }

    public void setRepository(IvyArtifactRepository repository) {
        this.repository.set((Object)((DefaultIvyArtifactRepository)repository));
        this.credentials.set((Provider)((DefaultIvyArtifactRepository)repository).getConfiguredCredentials());
    }

    @TaskAction
    public void publish() {
        PublishSpec spec = (PublishSpec)this.spec.get();
        IvyNormalizedPublication publication = spec.publication;
        IvyArtifactRepository repository = spec.repository.get(this.getServices());
        this.getDuplicatePublicationTracker().checkCanPublish(publication, repository.getUrl(), repository.getName());
        this.doPublish(publication, repository);
    }

    private PublishSpec computeSpec() {
        IvyPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        DefaultIvyArtifactRepository repository = (DefaultIvyArtifactRepository)this.repository.get();
        if (repository == null) {
            throw new InvalidUserDataException("The 'repository' property is required");
        }
        IvyNormalizedPublication normalizedPublication = publicationInternal.asNormalisedPublication();
        return new PublishSpec(RepositorySpec.of(repository), normalizedPublication);
    }

    @Inject
    protected IvyPublisher getIvyPublisher() {
        throw new UnsupportedOperationException();
    }

    private void doPublish(final IvyNormalizedPublication normalizedPublication, final IvyArtifactRepository repository) {
        new PublishOperation(normalizedPublication.getName(), repository.getName()){

            protected void publish() {
                IvyPublisher publisher = PublishToIvyRepository.this.getIvyPublisher();
                publisher.publish(normalizedPublication, repository);
            }
        }.run();
    }

    @Inject
    protected IvyDuplicatePublicationTracker getDuplicatePublicationTracker() {
        throw new UnsupportedOperationException();
    }

    static class PublishSpec {
        private final RepositorySpec repository;
        private final IvyNormalizedPublication publication;

        public PublishSpec(RepositorySpec repository, IvyNormalizedPublication publication) {
            this.repository = repository;
            this.publication = publication;
        }
    }

    static abstract class RepositorySpec {
        RepositorySpec() {
        }

        static RepositorySpec of(DefaultIvyArtifactRepository repository) {
            return new Configured(repository);
        }

        abstract IvyArtifactRepository get(ServiceRegistry var1);

        static class Configured
        extends RepositorySpec
        implements Serializable {
            final DefaultIvyArtifactRepository repository;

            public Configured(DefaultIvyArtifactRepository repository) {
                this.repository = repository;
            }

            @Override
            IvyArtifactRepository get(ServiceRegistry services) {
                return this.repository;
            }

            private Object writeReplace() {
                return new DefaultRepositorySpec(this.repository.getName(), this.repository.getUrl(), this.repository.isAllowInsecureProtocol(), this.credentialsSpec(), this.repository.getRepositoryLayout(), this.repository.additionalArtifactPatterns(), this.repository.additionalIvyPatterns(), this.repository.getConfiguredAuthentication());
            }

            private @Nullable CredentialsSpec credentialsSpec() {
                return (CredentialsSpec)this.repository.getConfiguredCredentials().map(credentials -> CredentialsSpec.of(this.repository.getName(), credentials)).getOrNull();
            }
        }

        static class CredentialsSpec {
            private final String identity;
            private final Class<? extends Credentials> type;

            private CredentialsSpec(String identity, Class<? extends Credentials> type) {
                this.identity = identity;
                this.type = type;
            }

            public static CredentialsSpec of(String identity, Credentials credentials) {
                return new CredentialsSpec(identity, GeneratedSubclasses.unpackType((Object)credentials));
            }

            public Class<? extends Credentials> getType() {
                return this.type;
            }

            public String getIdentity() {
                return this.identity;
            }
        }

        static class DefaultRepositorySpec
        extends RepositorySpec {
            private final URI repositoryUrl;
            private final CredentialsSpec credentials;
            private final AbstractRepositoryLayout layout;
            private final boolean allowInsecureProtocol;
            private final String name;
            private final Set<String> artifactPatterns;
            private final Set<String> ivyPatterns;
            private final Collection<Authentication> authentications;

            public DefaultRepositorySpec(String name, URI repositoryUrl, boolean allowInsecureProtocol, CredentialsSpec credentials, AbstractRepositoryLayout layout, Set<String> artifactPatterns, Set<String> ivyPatterns, Collection<Authentication> authentications) {
                this.name = name;
                this.repositoryUrl = repositoryUrl;
                this.allowInsecureProtocol = allowInsecureProtocol;
                this.credentials = credentials;
                this.layout = layout;
                this.artifactPatterns = artifactPatterns;
                this.ivyPatterns = ivyPatterns;
                this.authentications = authentications;
            }

            @Override
            IvyArtifactRepository get(ServiceRegistry services) {
                DefaultIvyArtifactRepository repository = (DefaultIvyArtifactRepository)((BaseRepositoryFactory)services.get(BaseRepositoryFactory.class)).createIvyRepository();
                repository.setName(this.name);
                repository.setUrl(this.repositoryUrl);
                this.artifactPatterns.forEach(arg_0 -> ((DefaultIvyArtifactRepository)repository).artifactPattern(arg_0));
                this.ivyPatterns.forEach(arg_0 -> ((DefaultIvyArtifactRepository)repository).ivyPattern(arg_0));
                repository.setAllowInsecureProtocol(this.allowInsecureProtocol);
                repository.setRepositoryLayout(this.layout);
                if (this.credentials != null) {
                    Provider provider = ((ProviderFactory)services.get(ProviderFactory.class)).credentials(this.credentials.getType(), this.name);
                    repository.setConfiguredCredentials((Credentials)provider.get());
                }
                repository.authentication(container -> container.addAll(this.authentications));
                return repository;
            }
        }
    }
}

