/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.tasks;

import com.google.common.base.Joiner;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyModuleDescriptorAuthor;
import org.gradle.api.publish.ivy.IvyModuleDescriptorDescription;
import org.gradle.api.publish.ivy.IvyModuleDescriptorLicense;
import org.gradle.api.publish.ivy.internal.artifact.IvyArtifactInternal;
import org.gradle.api.publish.ivy.internal.artifact.NormalizedIvyArtifact;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorSpecInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationCoordinates;
import org.gradle.internal.xml.SimpleXmlWriter;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.Nullable;

public final class IvyDescriptorFileGenerator {
    private static final String IVY_FILE_ENCODING = "UTF-8";
    private static final String IVY_DATE_PATTERN = "yyyyMMddHHmmss";

    private IvyDescriptorFileGenerator() {
    }

    public static DescriptorFileSpec generateSpec(IvyModuleDescriptorSpecInternal descriptor) {
        Set dependencies;
        Model model = new Model();
        IvyPublicationCoordinates coordinates = descriptor.getCoordinates();
        model.organisation = (String)coordinates.getOrganisation().get();
        model.module = (String)coordinates.getModule().get();
        model.revision = (String)coordinates.getRevision().get();
        model.status = descriptor.getStatus();
        model.branch = descriptor.getBranch();
        model.extraInfo = descriptor.getExtraInfo().asMap();
        model.description = descriptor.getDescription();
        model.authors.addAll(descriptor.getAuthors());
        model.licenses.addAll(descriptor.getLicenses());
        model.configurations.addAll((Collection)descriptor.getConfigurations().get());
        Set globalExcludes = (Set)descriptor.getGlobalExcludes().getOrNull();
        if (globalExcludes != null) {
            model.globalExcludes.addAll(globalExcludes);
        }
        if ((dependencies = (Set)descriptor.getDependencies().getOrNull()) != null) {
            model.dependencies.addAll(dependencies);
        }
        for (IvyArtifact ivyArtifact : (Set)descriptor.getArtifacts().get()) {
            model.artifacts.add(((IvyArtifactInternal)ivyArtifact).asNormalisedArtifact());
        }
        XmlTransformer xmlTransformer = new XmlTransformer();
        xmlTransformer.addAction(descriptor.getXmlAction());
        if (((Boolean)descriptor.getWriteGradleMetadataMarker().get()).booleanValue()) {
            xmlTransformer.addFinalizer(SerializableLambdas.action(IvyDescriptorFileGenerator::insertGradleMetadataMarker));
        }
        return new DescriptorFileSpec(model, xmlTransformer);
    }

    public static void insertGradleMetadataMarker(XmlProvider xmlProvider) {
        String comment = Joiner.on((String)"").join(Streams.concat((Stream[])new Stream[]{Arrays.stream(MetaDataParser.GRADLE_METADATA_MARKER_COMMENT_LINES), Stream.of("do_not_remove: published-with-gradle-metadata")}).map(content -> "<!-- " + content + " -->\n  ").iterator());
        StringBuilder builder = xmlProvider.asString();
        int idx = builder.indexOf("<info");
        builder.insert(idx, comment);
    }

    private static class Model {
        private String branch;
        private String status;
        private String organisation;
        private String module;
        private String revision;
        private final List<IvyModuleDescriptorLicense> licenses = new ArrayList<IvyModuleDescriptorLicense>();
        private final List<IvyModuleDescriptorAuthor> authors = new ArrayList<IvyModuleDescriptorAuthor>();
        private IvyModuleDescriptorDescription description;
        private Map<QName, String> extraInfo;
        private final List<IvyConfiguration> configurations = new ArrayList<IvyConfiguration>();
        private final List<NormalizedIvyArtifact> artifacts = new ArrayList<NormalizedIvyArtifact>();
        private final List<IvyDependency> dependencies = new ArrayList<IvyDependency>();
        private final List<IvyExcludeRule> globalExcludes = new ArrayList<IvyExcludeRule>();

        private Model() {
        }
    }

    public static class DescriptorFileSpec {
        private final Model model;
        private final XmlTransformer xmlTransformer;

        public DescriptorFileSpec(Model model, XmlTransformer xmlTransformer) {
            this.model = model;
            this.xmlTransformer = xmlTransformer;
        }

        public void writeTo(File destination) {
            this.xmlTransformer.transform(destination, IvyDescriptorFileGenerator.IVY_FILE_ENCODING, writer -> {
                try {
                    new ModelWriter(this.model).writeDescriptor(writer);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            });
        }
    }

    public static class ModelWriter {
        private final SimpleDateFormat ivyDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        private final Model model;

        public ModelWriter(Model model) {
            this.model = model;
        }

        private void writeDescriptor(Writer writer) throws IOException {
            OptionalAttributeXmlWriter xmlWriter = new OptionalAttributeXmlWriter(writer, "  ", IvyDescriptorFileGenerator.IVY_FILE_ENCODING);
            xmlWriter.startElement("ivy-module").attribute("version", "2.0");
            if (ModelWriter.usesClassifier(this.model)) {
                xmlWriter.attribute("xmlns:m", "http://ant.apache.org/ivy/maven");
            }
            xmlWriter.startElement("info").attribute("organisation", this.model.organisation).attribute("module", this.model.module).attribute("branch", this.model.branch).attribute("revision", this.model.revision).attribute("status", this.model.status).attribute("publication", this.ivyDateFormat.format(new Date()));
            for (IvyModuleDescriptorLicense ivyModuleDescriptorLicense : this.model.licenses) {
                xmlWriter.startElement("license").attribute("name", (String)ivyModuleDescriptorLicense.getName().getOrNull()).attribute("url", (String)ivyModuleDescriptorLicense.getUrl().getOrNull()).endElement();
            }
            for (IvyModuleDescriptorAuthor ivyModuleDescriptorAuthor : this.model.authors) {
                xmlWriter.startElement("ivyauthor").attribute("name", (String)ivyModuleDescriptorAuthor.getName().getOrNull()).attribute("url", (String)ivyModuleDescriptorAuthor.getUrl().getOrNull()).endElement();
            }
            if (this.model.description != null) {
                xmlWriter.startElement("description").attribute("homepage", (String)this.model.description.getHomepage().getOrNull()).characters((CharSequence)this.model.description.getText().getOrElse((Object)"")).endElement();
            }
            if (this.model.extraInfo != null) {
                for (Map.Entry entry : this.model.extraInfo.entrySet()) {
                    if (entry.getKey() == null) continue;
                    xmlWriter.startElement("ns:" + ((QName)entry.getKey()).getLocalPart()).attribute("xmlns:ns", ((QName)entry.getKey()).getNamespaceURI()).characters((CharSequence)entry.getValue()).endElement();
                }
            }
            xmlWriter.endElement();
            this.writeConfigurations(xmlWriter);
            this.writePublications(xmlWriter);
            this.writeDependencies(xmlWriter);
            xmlWriter.endElement();
        }

        private void writeConfigurations(OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("configurations");
            for (IvyConfiguration configuration : this.model.configurations) {
                xmlWriter.startElement("conf").attribute("name", configuration.getName()).attribute("visibility", "public");
                if (configuration.getExtends().size() > 0) {
                    xmlWriter.attribute("extends", CollectionUtils.join((String)",", configuration.getExtends()));
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }

        private void writePublications(OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("publications");
            for (IvyArtifact artifact : this.model.artifacts) {
                xmlWriter.startElement("artifact").attribute("name", artifact.getName()).attribute("type", artifact.getType()).attribute("ext", artifact.getExtension()).attribute("conf", artifact.getConf()).attribute("m:classifier", artifact.getClassifier()).endElement();
            }
            xmlWriter.endElement();
        }

        private void writeDependencies(OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("dependencies");
            for (IvyDependency dependency : this.model.dependencies) {
                String org = dependency.getOrganisation();
                String module = dependency.getModule();
                xmlWriter.startElement("dependency").attribute("org", org).attribute("name", module).attribute("rev", dependency.getRevision()).attribute("conf", dependency.getConfMapping()).attribute("revConstraint", dependency.getRevConstraint());
                if (!dependency.isTransitive()) {
                    xmlWriter.attribute("transitive", "false");
                }
                for (DependencyArtifact dependencyArtifact : dependency.getArtifacts()) {
                    ModelWriter.writeDependencyArtifact(dependencyArtifact, xmlWriter);
                }
                for (ExcludeRule excludeRule : dependency.getExcludeRules()) {
                    ModelWriter.writeDependencyExclude(excludeRule, xmlWriter);
                }
                xmlWriter.endElement();
            }
            for (IvyExcludeRule excludeRule : this.model.globalExcludes) {
                ModelWriter.writeGlobalExclude(excludeRule, xmlWriter);
            }
            xmlWriter.endElement();
        }

        private static void writeDependencyExclude(ExcludeRule excludeRule, OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("exclude").attribute("org", excludeRule.getGroup()).attribute("module", excludeRule.getModule()).endElement();
        }

        private static void writeDependencyArtifact(DependencyArtifact dependencyArtifact, OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("artifact").attribute("name", dependencyArtifact.getName()).attribute("type", dependencyArtifact.getType()).attribute("ext", dependencyArtifact.getExtension()).attribute("m:classifier", dependencyArtifact.getClassifier()).endElement();
        }

        private static void writeGlobalExclude(IvyExcludeRule excludeRule, OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("exclude").attribute("org", excludeRule.getOrg()).attribute("module", excludeRule.getModule()).attribute("conf", excludeRule.getConf()).endElement();
        }

        private static boolean usesClassifier(Model model) {
            for (IvyArtifact artifact : model.artifacts) {
                if (artifact.getClassifier() == null) continue;
                return true;
            }
            for (IvyDependency dependency : model.dependencies) {
                for (DependencyArtifact dependencyArtifact : dependency.getArtifacts()) {
                    if (dependencyArtifact.getClassifier() == null) continue;
                    return true;
                }
            }
            return false;
        }

        private static class OptionalAttributeXmlWriter
        extends SimpleXmlWriter {
            public OptionalAttributeXmlWriter(Writer writer, String indent, String encoding) throws IOException {
                super(writer, indent, encoding);
            }

            public OptionalAttributeXmlWriter startElement(String name) throws IOException {
                super.startElement(name);
                return this;
            }

            public OptionalAttributeXmlWriter attribute(String name, @Nullable String value) throws IOException {
                if (value != null) {
                    super.attribute(name, value);
                }
                return this;
            }

            public OptionalAttributeXmlWriter comment(String comment) throws IOException {
                super.comment(comment);
                return this;
            }
        }
    }
}

