/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import groovy.namespace.QName;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.xml.XmlParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.exceptions.MarkedVerificationException;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.internal.CheckstyleActionParameters;
import org.gradle.api.plugins.quality.internal.CheckstyleInvocationException;
import org.gradle.api.provider.Property;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.VersionNumber;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class CheckstyleInvoker
implements Action<AntBuilderDelegate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckstyleInvoker.class);
    private static final String FAILURE_PROPERTY_NAME = "org.gradle.checkstyle.violations";
    private static final String CONFIG_LOC_PROPERTY = "config_loc";
    private final CheckstyleActionParameters parameters;

    CheckstyleInvoker(CheckstyleActionParameters parameters) {
        this.parameters = parameters;
    }

    public void execute(AntBuilderDelegate ant) {
        boolean hasAFailure;
        FileTree source = this.parameters.getSource().getAsFileTree();
        boolean showViolations = (Boolean)this.parameters.getShowViolations().get();
        int maxErrors = (Integer)this.parameters.getMaxErrors().get();
        int maxWarnings = (Integer)this.parameters.getMaxWarnings().get();
        Map configProperties = (Map)this.parameters.getConfigProperties().get();
        boolean ignoreFailures = (Boolean)this.parameters.getIgnoreFailures().get();
        RegularFile config = (RegularFile)this.parameters.getConfig().get();
        File configDir = (File)this.parameters.getConfigDirectory().getAsFile().get();
        boolean isXmlRequired = (Boolean)this.parameters.getIsXmlRequired().get();
        boolean isHtmlRequired = (Boolean)this.parameters.getIsHtmlRequired().get();
        boolean isSarifRequired = (Boolean)this.parameters.getIsSarifRequired().get();
        File xmlOutputLocation = this.getXmlOutputLocation(isXmlRequired, isHtmlRequired);
        Property<String> stylesheetString = this.parameters.getStylesheetString();
        File htmlOutputLocation = (File)this.parameters.getHtmlOutputLocation().getAsFile().getOrNull();
        File sarifOutputLocation = (File)this.parameters.getSarifOutputLocation().getAsFile().getOrNull();
        VersionNumber currentToolVersion = CheckstyleInvoker.determineCheckstyleVersion(Thread.currentThread().getContextClassLoader());
        Object userProvidedConfigLoc = configProperties.get(CONFIG_LOC_PROPERTY);
        if (userProvidedConfigLoc != null) {
            throw new InvalidUserDataException("Cannot add config_loc to checkstyle.configProperties. Please configure the configDirectory on the checkstyle task instead.");
        }
        if (isSarifRequired && !CheckstyleInvoker.isSarifSupported(currentToolVersion)) {
            CheckstyleInvoker.assertUnsupportedReportFormatSARIF(currentToolVersion);
        }
        try {
            ant.taskdef((Map)ImmutableMap.of((Object)"name", (Object)"checkstyle", (Object)"classname", (Object)"com.puppycrawl.tools.checkstyle.CheckStyleTask"));
        }
        catch (RuntimeException ignore) {
            ant.taskdef((Map)ImmutableMap.of((Object)"name", (Object)"checkstyle", (Object)"classname", (Object)"com.puppycrawl.tools.checkstyle.ant.CheckstyleAntTask"));
        }
        try {
            ant.invokeMethod("checkstyle", (Map)ImmutableMap.of((Object)"config", (Object)config.getAsFile(), (Object)"failOnViolation", (Object)false, (Object)"maxErrors", (Object)maxErrors, (Object)"maxWarnings", (Object)maxWarnings, (Object)"failureProperty", (Object)FAILURE_PROPERTY_NAME), () -> {
                source.addToAntBuilder((Object)ant, "fileset", FileCollection.AntType.FileSet);
                if (showViolations) {
                    ant.invokeMethod("formatter", (Object)ImmutableMap.of((Object)"type", (Object)"plain", (Object)"useFile", (Object)false));
                }
                if (isXmlRequired || isHtmlRequired) {
                    ant.invokeMethod("formatter", (Object)ImmutableMap.of((Object)"type", (Object)"xml", (Object)"toFile", (Object)((Serializable)Preconditions.checkNotNull((Object)xmlOutputLocation, (Object)"Xml report output location is required when xml or html report is requested."))));
                }
                if (isSarifRequired) {
                    ant.invokeMethod("formatter", (Object)ImmutableMap.of((Object)"type", (Object)"sarif", (Object)"toFile", (Object)((Serializable)Preconditions.checkNotNull((Object)sarifOutputLocation, (Object)"SARIF report output location is required when SARIF report is requested."))));
                }
                configProperties.forEach((key, value) -> ant.invokeMethod("property", (Object)ImmutableMap.of((Object)"key", (Object)key, (Object)"value", (Object)value.toString())));
                ant.invokeMethod("property", (Object)ImmutableMap.of((Object)"key", (Object)CONFIG_LOC_PROPERTY, (Object)"value", (Object)configDir.toString()));
            });
        }
        catch (Exception e) {
            throw new CheckstyleInvocationException("An unexpected error occurred configuring and executing Checkstyle.", e);
        }
        if (isHtmlRequired) {
            String stylesheet = stylesheetString.isPresent() ? (String)stylesheetString.get() : CheckstyleInvoker.readText(Checkstyle.class.getClassLoader().getResourceAsStream("checkstyle-noframes-sorted.xsl"));
            ant.invokeMethod("xslt", (Map)ImmutableMap.of((Object)"in", (Object)Preconditions.checkNotNull((Object)xmlOutputLocation), (Object)"out", (Object)Preconditions.checkNotNull((Object)htmlOutputLocation)), () -> {
                ant.invokeMethod("param", (Object)ImmutableMap.of((Object)"name", (Object)"gradleVersion", (Object)"expression", (Object)GradleVersion.current().toString()));
                ant.invokeMethod("style", () -> ant.invokeMethod("string", (Object)ImmutableMap.of((Object)"value", (Object)stylesheet)));
            });
        }
        if (CheckstyleInvoker.isHtmlReportEnabledOnly(isXmlRequired, isHtmlRequired)) {
            GFileUtils.deleteQuietly((File)xmlOutputLocation);
        }
        Node reportXml = CheckstyleInvoker.parseCheckstyleXml(isXmlRequired, xmlOutputLocation);
        String message = CheckstyleInvoker.getMessage(isXmlRequired, xmlOutputLocation, isHtmlRequired, htmlOutputLocation, isSarifRequired, sarifOutputLocation, reportXml);
        boolean bl = hasAFailure = ant.getProjectProperties().get(FAILURE_PROPERTY_NAME) != null;
        if (hasAFailure && !ignoreFailures) {
            throw new MarkedVerificationException(message);
        }
        if (CheckstyleInvoker.violationsExist(reportXml)) {
            LOGGER.warn(message);
        }
    }

    private @Nullable File getXmlOutputLocation(boolean isXmlRequired, boolean isHtmlRequired) {
        File xmlOutputLocation = (File)this.parameters.getXmlOutputLocation().getAsFile().getOrNull();
        if (CheckstyleInvoker.isHtmlReportEnabledOnly(isXmlRequired, isHtmlRequired)) {
            Preconditions.checkNotNull((Object)xmlOutputLocation, (Object)"Xml report output location is required when html report is requested.");
            return new File((File)this.parameters.getTemporaryDir().getAsFile().get(), xmlOutputLocation.getName());
        }
        return xmlOutputLocation;
    }

    private static VersionNumber determineCheckstyleVersion(ClassLoader antLoader) {
        Class<?> checkstyleTaskClass;
        try {
            checkstyleTaskClass = antLoader.loadClass("com.puppycrawl.tools.checkstyle.CheckStyleTask");
        }
        catch (ClassNotFoundException e) {
            try {
                checkstyleTaskClass = antLoader.loadClass("com.puppycrawl.tools.checkstyle.ant.CheckstyleAntTask");
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return VersionNumber.parse((String)checkstyleTaskClass.getPackage().getImplementationVersion());
    }

    private static boolean isSarifSupported(VersionNumber versionNumber) {
        return versionNumber.compareTo(VersionNumber.parse((String)"10.3.3")) >= 0;
    }

    private static void assertUnsupportedReportFormatSARIF(VersionNumber version) {
        throw new GradleException("SARIF report format is supported on Checkstyle versions 10.3.3 and newer. Please upgrade from Checkstyle " + version + " or disable the SARIF format.");
    }

    private static @Nullable Node parseCheckstyleXml(Boolean isXmlRequired, File xmlOutputLocation) {
        try {
            return isXmlRequired != false ? new XmlParser().parse(xmlOutputLocation) : null;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getMessage(Boolean isXmlRequired, File xmlOutputLocation, Boolean isHtmlRequired, File htmlOutputLocation, Boolean isSarifRequired, File sarifOutputLocation, Node reportXml) {
        return String.format("Checkstyle rule violations were found.%s%s", CheckstyleInvoker.getReportUrlMessage(isXmlRequired, xmlOutputLocation, isHtmlRequired, htmlOutputLocation, isSarifRequired, sarifOutputLocation), CheckstyleInvoker.getViolationMessage(reportXml));
    }

    private static String getReportUrlMessage(Boolean isXmlRequired, File xmlOutputLocation, Boolean isHtmlRequired, File htmlOutputLocation, Boolean isSarifRequired, File sarifOutputLocation) {
        File outputLocation = isHtmlRequired != false ? htmlOutputLocation : (isXmlRequired != false ? xmlOutputLocation : (isSarifRequired != false ? sarifOutputLocation : null));
        return outputLocation != null ? String.format(" See the report at: %s", new ConsoleRenderer().asClickableFileUrl(outputLocation)) : "\n";
    }

    private static String getViolationMessage(@Nullable Node reportXml) {
        if (CheckstyleInvoker.violationsExist(reportXml)) {
            int errorFileCount = CheckstyleInvoker.getErrorFileCount(reportXml);
            List<String> violations = CheckstyleInvoker.getViolations(reportXml);
            return String.format("\nCheckstyle files with violations: %s\nCheckstyle violations by severity: %s\n", errorFileCount, violations);
        }
        return "\n";
    }

    private static String readText(InputStream stream) {
        try {
            return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static List<String> getViolations(Node reportXml) {
        NodeList errorNodes = reportXml.getAt(QName.valueOf((String)"file")).getAt("error");
        return errorNodes.stream().map(node -> (String)node.attribute((Object)"severity")).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.toList());
    }

    private static boolean violationsExist(@Nullable Node reportXml) {
        return reportXml != null && CheckstyleInvoker.getErrorFileCount(reportXml) > 0;
    }

    private static int getErrorFileCount(Node reportXml) {
        int count = 0;
        for (Object node : reportXml.getAt(QName.valueOf((String)"file"))) {
            NodeList errors = ((Node)node).getAt(QName.valueOf((String)"error"));
            if (errors.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    private static boolean isHtmlReportEnabledOnly(boolean isXmlRequired, boolean isHtmlRequired) {
        return !isXmlRequired && isHtmlRequired;
    }
}

