/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.wrapper.internal;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.wrapper.WrapperVersionsResources;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.jspecify.annotations.Nullable;

public class DefaultWrapperVersionsResources
implements WrapperVersionsResources {
    public static final String LATEST = "latest";
    public static final String NIGHTLY = "nightly";
    public static final String RELEASE_NIGHTLY = "release-nightly";
    public static final String RELEASE_CANDIDATE = "release-candidate";
    public static final List<String> PLACE_HOLDERS = Arrays.asList("latest", "release-candidate", "release-nightly", "nightly");
    private final TextResource latest;
    private final TextResource releaseCandidate;
    private final TextResource nightly;
    private final TextResource releaseNightly;

    public DefaultWrapperVersionsResources(TextResource latest, TextResource releaseCandidate, TextResource nightly, TextResource releaseNightly) {
        this.latest = latest;
        this.releaseCandidate = releaseCandidate;
        this.nightly = nightly;
        this.releaseNightly = releaseNightly;
    }

    public TextResource getLatest() {
        return this.latest;
    }

    public TextResource getReleaseCandidate() {
        return this.releaseCandidate;
    }

    public TextResource getNightly() {
        return this.nightly;
    }

    public TextResource getReleaseNightly() {
        return this.releaseNightly;
    }

    public static final class WrapperVersionException
    extends GradleException
    implements ResolutionProvider {
        public WrapperVersionException(String message) {
            super(message);
        }

        public WrapperVersionException(String message, @Nullable Throwable cause) {
            super(message, cause);
        }

        public List<String> getResolutions() {
            return Arrays.asList(this.suggestActualVersion(), this.suggestDynamicVersions());
        }

        private String suggestActualVersion() {
            return "Specify a valid Gradle release listed on https://gradle.org/releases/.";
        }

        private String suggestDynamicVersions() {
            String validStrings = PLACE_HOLDERS.stream().map(s -> String.format("'%s'", s)).collect(Collectors.joining(", "));
            return String.format("Use one of the following dynamic version specifications: %s.", validStrings);
        }
    }
}

