/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.BaseExecHandleBuilder;
import org.gradle.process.internal.ClientExecHandleBuilder;
import org.gradle.process.internal.EffectiveJavaForkOptions;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.process.internal.ProcessArgumentsSpec;
import org.gradle.process.internal.util.LongCommandLineDetectionUtil;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class JavaExecHandleBuilder
implements BaseExecHandleBuilder,
ProcessArgumentsSpec.HasExecutable {
    private static final Logger LOGGER = Logging.getLogger(JavaExecHandleBuilder.class);
    private final FileCollectionFactory fileCollectionFactory;
    private final TemporaryFileProvider temporaryFileProvider;
    private final JavaModuleDetector javaModuleDetector;
    private final Property<String> mainModule;
    private final Property<String> mainClass;
    private final ListProperty<String> jvmArguments;
    private final ClientExecHandleBuilder execHandleBuilder;
    private ConfigurableFileCollection classpath;
    private final JavaForkOptionsInternal javaOptions;
    private final ModularitySpec modularity;

    public JavaExecHandleBuilder(FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, TemporaryFileProvider temporaryFileProvider, @Nullable JavaModuleDetector javaModuleDetector, JavaForkOptionsInternal javaOptions, ClientExecHandleBuilder execHandleBuilder) {
        this.fileCollectionFactory = fileCollectionFactory;
        this.temporaryFileProvider = temporaryFileProvider;
        this.javaModuleDetector = javaModuleDetector;
        this.classpath = fileCollectionFactory.configurableFiles("classpath");
        this.mainModule = objectFactory.property(String.class);
        this.mainClass = objectFactory.property(String.class);
        this.jvmArguments = objectFactory.listProperty(String.class);
        this.javaOptions = javaOptions;
        this.modularity = new DefaultModularitySpec(objectFactory);
        this.execHandleBuilder = execHandleBuilder;
        this.setExecutable(javaOptions.getExecutable());
    }

    public List<String> getAllJvmArgs() {
        return this.getAllJvmArgs((FileCollection)this.classpath);
    }

    private List<String> getAllJvmArgs(FileCollection realClasspath) {
        boolean runAsModule;
        ArrayList<String> allArgs = new ArrayList<String>(this.javaOptions.getAllJvmArgs());
        boolean bl = runAsModule = (Boolean)this.modularity.getInferModulePath().get() != false && this.mainModule.isPresent();
        if (runAsModule) {
            this.addModularJavaRunArgs(realClasspath, allArgs);
        } else {
            this.addClassicJavaRunArgs(realClasspath, allArgs);
        }
        return allArgs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addClassicJavaRunArgs(FileCollection classpath, List<String> allArgs) {
        if (!this.mainClass.isPresent()) {
            if (classpath == null || classpath.getFiles().size() != 1) throw new IllegalStateException("No main class specified and classpath is not an executable jar.");
            allArgs.add("-jar");
            allArgs.add(classpath.getSingleFile().getAbsolutePath());
            return;
        } else {
            if (classpath != null && !classpath.isEmpty()) {
                allArgs.add("-cp");
                allArgs.add(CollectionUtils.join((String)File.pathSeparator, (Iterable)classpath));
            }
            allArgs.add((String)this.mainClass.get());
        }
    }

    private void addModularJavaRunArgs(FileCollection classpath, List<String> allArgs) {
        if (this.javaModuleDetector == null) {
            throw new IllegalStateException("Running a Java module is not supported in this context.");
        }
        FileCollection rtModulePath = this.javaModuleDetector.inferModulePath(((Boolean)this.modularity.getInferModulePath().get()).booleanValue(), classpath);
        FileCollection rtClasspath = this.javaModuleDetector.inferClasspath(((Boolean)this.modularity.getInferModulePath().get()).booleanValue(), classpath);
        if (rtClasspath != null && !rtClasspath.isEmpty()) {
            allArgs.add("-cp");
            allArgs.add(CollectionUtils.join((String)File.pathSeparator, (Iterable)rtClasspath));
        }
        if (rtModulePath != null && !rtModulePath.isEmpty()) {
            allArgs.add("--module-path");
            allArgs.add(CollectionUtils.join((String)File.pathSeparator, (Iterable)rtModulePath));
        }
        allArgs.add("--module");
        if (!this.mainClass.isPresent()) {
            allArgs.add((String)this.mainModule.get());
        } else {
            allArgs.add((String)this.mainModule.get() + "/" + (String)this.mainClass.get());
        }
    }

    public List<String> getJvmArgs() {
        return this.javaOptions.getJvmArgs();
    }

    public void setJvmArgs(List<String> arguments) {
        this.javaOptions.setJvmArgs(arguments);
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.javaOptions.setJvmArgs(arguments);
    }

    public JavaExecHandleBuilder jvmArgs(Iterable<?> arguments) {
        this.javaOptions.jvmArgs(arguments);
        return this;
    }

    public JavaExecHandleBuilder jvmArgs(Object ... arguments) {
        this.javaOptions.jvmArgs(arguments);
        return this;
    }

    public ListProperty<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public Map<String, Object> getSystemProperties() {
        return this.javaOptions.getSystemProperties();
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.javaOptions.setSystemProperties(properties);
    }

    public JavaExecHandleBuilder systemProperties(Map<String, ?> properties) {
        this.javaOptions.systemProperties(properties);
        return this;
    }

    public JavaExecHandleBuilder systemProperty(String name, Object value) {
        this.javaOptions.systemProperty(name, value);
        return this;
    }

    public FileCollection getBootstrapClasspath() {
        return this.javaOptions.getBootstrapClasspath();
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.javaOptions.setBootstrapClasspath(classpath);
    }

    public JavaExecHandleBuilder bootstrapClasspath(Object ... classpath) {
        this.javaOptions.bootstrapClasspath(classpath);
        return this;
    }

    public String getMinHeapSize() {
        return this.javaOptions.getMinHeapSize();
    }

    public void setMinHeapSize(String heapSize) {
        this.javaOptions.setMinHeapSize(heapSize);
    }

    public String getDefaultCharacterEncoding() {
        return this.javaOptions.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.javaOptions.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public String getMaxHeapSize() {
        return this.javaOptions.getMaxHeapSize();
    }

    public void setMaxHeapSize(String heapSize) {
        this.javaOptions.setMaxHeapSize(heapSize);
    }

    public boolean getEnableAssertions() {
        return this.javaOptions.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.javaOptions.setEnableAssertions(enabled);
    }

    public boolean getDebug() {
        return this.javaOptions.getDebug();
    }

    public void setDebug(boolean enabled) {
        this.javaOptions.setDebug(enabled);
    }

    public JavaDebugOptions getDebugOptions() {
        return this.javaOptions.getDebugOptions();
    }

    public void debugOptions(Action<JavaDebugOptions> action) {
        this.javaOptions.debugOptions(action);
    }

    @Override
    public String getExecutable() {
        return this.javaOptions.getExecutable();
    }

    @Override
    public void setExecutable(Object executable) {
        this.javaOptions.setExecutable(executable);
    }

    public void setExecutable(String executable) {
        this.javaOptions.setExecutable(executable);
    }

    public @Nullable File getWorkingDir() {
        return this.javaOptions.getWorkingDir();
    }

    public void setWorkingDir(@Nullable Object dir) {
        this.javaOptions.setWorkingDir(dir);
    }

    public void setWorkingDir(@Nullable File dir) {
        this.javaOptions.setWorkingDir(dir);
    }

    public Map<String, Object> getEnvironment() {
        return this.javaOptions.getEnvironment();
    }

    public JavaExecHandleBuilder setEnvironment(Map<String, ?> environmentVariables) {
        this.javaOptions.setEnvironment(environmentVariables);
        return this;
    }

    public JavaExecHandleBuilder environment(Map<String, ?> environmentVariables) {
        this.javaOptions.environment(environmentVariables);
        return this;
    }

    public JavaExecHandleBuilder environment(String name, Object value) {
        this.javaOptions.environment(name, value);
        return this;
    }

    public Property<String> getMainModule() {
        return this.mainModule;
    }

    public Property<String> getMainClass() {
        return this.mainClass;
    }

    public @NonNull List<String> getArgs() {
        return this.execHandleBuilder.getArgs();
    }

    public JavaExecHandleBuilder setArgs(List<String> applicationArgs) {
        this.execHandleBuilder.setArgs(applicationArgs);
        return this;
    }

    public JavaExecHandleBuilder setArgs(Iterable<?> applicationArgs) {
        this.execHandleBuilder.setArgs(applicationArgs);
        return this;
    }

    public JavaExecHandleBuilder args(Object ... args) {
        this.execHandleBuilder.args(args);
        return this;
    }

    public JavaExecHandleBuilder args(Iterable<?> args) {
        this.execHandleBuilder.args(args);
        return this;
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.execHandleBuilder.getArgumentProviders();
    }

    public JavaExecHandleBuilder setClasspath(FileCollection classpath) {
        ConfigurableFileCollection newClasspath = this.fileCollectionFactory.configurableFiles("classpath");
        newClasspath.setFrom((Iterable)classpath);
        this.classpath = newClasspath;
        return this;
    }

    public ModularitySpec getModularity() {
        return this.modularity;
    }

    public JavaExecHandleBuilder classpath(Object ... paths) {
        this.classpath.from(paths);
        return this;
    }

    public FileCollection getClasspath() {
        return this.classpath;
    }

    public List<String> getAllArguments() {
        return this.getAllArguments((FileCollection)this.classpath);
    }

    private List<String> getAllArguments(FileCollection realClasspath) {
        ArrayList<String> arguments = new ArrayList<String>(this.getAllJvmArgs(realClasspath));
        arguments.addAll(this.execHandleBuilder.getAllArguments());
        return arguments;
    }

    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        return this.javaOptions.getJvmArgumentProviders();
    }

    public void setStandardInput(InputStream inputStream) {
        this.execHandleBuilder.setStandardInput(inputStream);
    }

    public InputStream getStandardInput() {
        return this.execHandleBuilder.getStandardInput();
    }

    public OutputStream getStandardOutput() {
        return this.execHandleBuilder.getStandardOutput();
    }

    public JavaExecHandleBuilder setStandardOutput(OutputStream outputStream) {
        this.execHandleBuilder.setStandardOutput(outputStream);
        return this;
    }

    public OutputStream getErrorOutput() {
        return this.execHandleBuilder.getErrorOutput();
    }

    public JavaExecHandleBuilder setErrorOutput(OutputStream outputStream) {
        this.execHandleBuilder.setErrorOutput(outputStream);
        return this;
    }

    public List<String> getCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getExecutable());
        commandLine.addAll(this.getAllArguments());
        return commandLine;
    }

    public JavaExecHandleBuilder listener(ExecHandleListener listener) {
        this.execHandleBuilder.listener(listener);
        return this;
    }

    public JavaExecHandleBuilder setDisplayName(@Nullable String displayName) {
        this.execHandleBuilder.setDisplayName(displayName);
        return this;
    }

    private List<String> getEffectiveArguments() {
        List<String> arguments = this.getAllArguments();
        if (LongCommandLineDetectionUtil.hasCommandLineExceedMaxLength(this.getExecutable(), arguments)) {
            try {
                File pathingJarFile = this.writePathingJarFile((FileCollection)this.classpath);
                ConfigurableFileCollection shortenedClasspath = this.fileCollectionFactory.configurableFiles();
                shortenedClasspath.from(new Object[]{pathingJarFile});
                List<String> shortenedArguments = this.getAllArguments((FileCollection)shortenedClasspath);
                LOGGER.info("Shortening Java classpath {} with {}", (Object)this.classpath.getFiles(), (Object)pathingJarFile);
                return shortenedArguments;
            }
            catch (IOException e) {
                LOGGER.info("Pathing JAR could not be created, Gradle cannot shorten the command line.", (Throwable)e);
            }
        }
        return arguments;
    }

    private File writePathingJarFile(FileCollection classpath) throws IOException {
        File pathingJarFile = this.temporaryFileProvider.createTemporaryFile("gradle-javaexec-classpath", ".jar", new String[0]);
        try (FileOutputStream fileOutputStream = new FileOutputStream(pathingJarFile);
             JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, JavaExecHandleBuilder.toManifest(classpath));){
            jarOutputStream.putNextEntry(new ZipEntry("META-INF/"));
        }
        return pathingJarFile;
    }

    private static Manifest toManifest(FileCollection classpath) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue("Class-Path", classpath.getFiles().stream().map(File::toURI).map(URI::toString).collect(Collectors.joining(" ")));
        return manifest;
    }

    public JavaExecHandleBuilder redirectErrorStream() {
        this.execHandleBuilder.redirectErrorStream();
        return this;
    }

    @Deprecated
    public JavaExecHandleBuilder setIgnoreExitValue(boolean ignoreExitValue) {
        return this;
    }

    public void copyJavaForkOptions(JavaForkOptions source) {
        source.copyTo((JavaForkOptions)this.javaOptions);
    }

    public void copyJavaForkOptions(EffectiveJavaForkOptions.ReadOnlyJvmOptions source) {
        source.copyTo(this.javaOptions);
    }

    public ExecHandle build() {
        this.execHandleBuilder.setExecutable(this.getExecutable());
        this.execHandleBuilder.setWorkingDir(this.getWorkingDir());
        this.execHandleBuilder.setEnvironment(this.getEnvironment());
        return this.execHandleBuilder.buildWithEffectiveArguments(this.getEffectiveArguments());
    }
}

