/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.ExceptionContextVisitor;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.util.internal.TreeVisitor;
import org.jspecify.annotations.Nullable;

public class ContextAwareException
extends GradleException {
    public ContextAwareException(Throwable t) {
        this.initCause(t);
    }

    public List<Throwable> getReportableCauses() {
        final ArrayList<Throwable> causes = new ArrayList<Throwable>();
        this.visitCauses(this.getCause(), (TreeVisitor<? super Throwable>)new TreeVisitor<Throwable>(){

            @Override
            public void node(Throwable node) {
                causes.add(node);
            }
        });
        return causes;
    }

    public void accept(ExceptionContextVisitor contextVisitor) {
        Throwable cause = this.getCause();
        if (cause != null) {
            contextVisitor.visitCause(cause);
            this.visitCauses(cause, contextVisitor);
        }
        contextVisitor.endVisiting();
    }

    private void visitCauses(Throwable t, TreeVisitor<? super Throwable> visitor) {
        if (t instanceof MultiCauseException) {
            MultiCauseException multiCauseException = (MultiCauseException)t;
            List causes = multiCauseException.getCauses();
            if (!causes.isEmpty()) {
                visitor.startChildren();
                for (Throwable cause : causes) {
                    this.visitContextual(cause, visitor);
                }
                visitor.endChildren();
            }
        } else if (t.getCause() != null) {
            visitor.startChildren();
            this.visitContextual(t.getCause(), visitor);
            visitor.endChildren();
        }
    }

    private void visitContextual(Throwable t, TreeVisitor<? super Throwable> visitor) {
        Throwable next = this.findNearestContextual(t);
        if (next != null) {
            visitor.node(next);
            this.visitCauses(next, visitor);
        } else {
            visitor.node(t);
        }
    }

    private @Nullable Throwable findNearestContextual(@Nullable Throwable t) {
        if (t == null) {
            return null;
        }
        if (t.getClass().getAnnotation(Contextual.class) != null || t instanceof MultiCauseException) {
            return t;
        }
        return this.findNearestContextual(t.getCause());
    }
}

