/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import groovy.lang.Binding;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.io.PrintStream;
import java.util.Map;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.project.DynamicLookupRoutine;
import org.gradle.groovy.scripts.Script;
import org.gradle.internal.logging.StandardOutputCapture;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.DynamicObjectUtil;
import org.gradle.internal.scripts.GradleScript;
import org.gradle.internal.service.ServiceRegistry;

public abstract class BasicScript
extends Script
implements org.gradle.api.Script,
DynamicObjectAware,
GradleScript {
    private StandardOutputCapture standardOutputCapture;
    private Object target;
    private final ScriptDynamicObject dynamicObject = new ScriptDynamicObject(this);
    private DynamicLookupRoutine dynamicLookupRoutine;

    @Override
    public void init(Object target, ServiceRegistry services) {
        this.standardOutputCapture = (StandardOutputCapture)services.get(StandardOutputCapture.class);
        this.dynamicLookupRoutine = (DynamicLookupRoutine)services.get(DynamicLookupRoutine.class);
        this.setScriptTarget(target);
    }

    public Object getScriptTarget() {
        return this.target;
    }

    private void setScriptTarget(Object target) {
        this.target = target;
        this.dynamicObject.setTarget(target);
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.standardOutputCapture;
    }

    public PrintStream getOut() {
        return System.out;
    }

    public Object getProperty(String property) {
        return this.dynamicLookupRoutine.property((DynamicObject)this.dynamicObject, property);
    }

    public void setProperty(String property, Object newValue) {
        this.dynamicLookupRoutine.setProperty((DynamicObject)this.dynamicObject, property, newValue);
    }

    public Map<String, ?> getProperties() {
        return this.dynamicLookupRoutine.getProperties((DynamicObject)this.dynamicObject);
    }

    public boolean hasProperty(String property) {
        return this.dynamicLookupRoutine.hasProperty((DynamicObject)this.dynamicObject, property);
    }

    public Object invokeMethod(String name, Object args) {
        return this.dynamicLookupRoutine.invokeMethod((DynamicObject)this.dynamicObject, name, (Object[])args);
    }

    public DynamicObject getAsDynamicObject() {
        return this.dynamicObject;
    }

    private static final class ScriptDynamicObject
    extends AbstractDynamicObject {
        private final Binding binding;
        private final DynamicObject scriptObject;
        private DynamicObject dynamicTarget;

        ScriptDynamicObject(BasicScript script) {
            this.binding = script.getBinding();
            this.dynamicTarget = this.scriptObject = new BeanDynamicObject((Object)script).withNotImplementsMissing();
        }

        public void setTarget(Object target) {
            this.dynamicTarget = DynamicObjectUtil.asDynamicObject((Object)target);
        }

        public Map<String, ?> getProperties() {
            return this.dynamicTarget.getProperties();
        }

        public boolean hasMethod(String name, Object ... arguments) {
            return this.scriptObject.hasMethod(name, arguments) || this.dynamicTarget.hasMethod(name, arguments);
        }

        public boolean hasProperty(String name) {
            return this.binding.hasVariable(name) || this.scriptObject.hasProperty(name) || this.dynamicTarget.hasProperty(name);
        }

        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            DynamicInvokeResult result = this.scriptObject.tryInvokeMethod(name, arguments);
            if (result.isFound()) {
                return result;
            }
            return this.dynamicTarget.tryInvokeMethod(name, arguments);
        }

        public DynamicInvokeResult tryGetProperty(String property) {
            if (this.binding.hasVariable(property)) {
                return DynamicInvokeResult.found((Object)this.binding.getVariable(property));
            }
            DynamicInvokeResult result = this.scriptObject.tryGetProperty(property);
            if (result.isFound()) {
                return result;
            }
            return this.dynamicTarget.tryGetProperty(property);
        }

        public DynamicInvokeResult trySetProperty(String property, Object newValue) {
            return this.dynamicTarget.trySetProperty(property, newValue);
        }

        public DynamicInvokeResult trySetPropertyWithoutInstrumentation(String name, Object value) {
            return this.dynamicTarget.trySetPropertyWithoutInstrumentation(name, value);
        }

        public MissingPropertyException getMissingProperty(String name) {
            return this.dynamicTarget.getMissingProperty(name);
        }

        public MissingMethodException methodMissingException(String name, Object ... params) {
            return this.dynamicTarget.methodMissingException(name, params);
        }

        public MissingPropertyException setMissingProperty(String name) {
            return this.dynamicTarget.setMissingProperty(name);
        }

        public String getDisplayName() {
            return this.dynamicTarget.toString();
        }
    }
}

