/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GeneralDataSpec;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.specs.Spec;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.TaskSelectionResult;
import org.gradle.execution.TaskSelector;
import org.gradle.util.internal.NameMatcher;
import org.jspecify.annotations.NonNull;

public class DefaultTaskSelector
implements TaskSelector {
    private static final Logger LOGGER = Logging.getLogger(DefaultTaskSelector.class);
    private final TaskNameResolver taskNameResolver;
    private final ProjectConfigurer configurer;

    @Inject
    public DefaultTaskSelector(TaskNameResolver taskNameResolver, ProjectConfigurer configurer) {
        this.taskNameResolver = taskNameResolver;
        this.configurer = configurer;
    }

    @Inject
    protected InternalProblems getProblemsService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spec<Task> getFilter(TaskSelector.SelectionContext context, ProjectState project, String taskName, boolean includeSubprojects) {
        if (includeSubprojects) {
            this.configurer.configure(project.getMutableModel());
            if (this.taskNameResolver.tryFindUnqualifiedTaskCheaply(taskName, project.getMutableModel())) {
                return new TaskPathSpec(project.getMutableModel(), taskName);
            }
        }
        Set<Task> selectedTasks = this.getSelection(context, project, taskName, includeSubprojects).getTasks();
        return element -> !selectedTasks.contains(element);
    }

    @Override
    public TaskSelection getSelection(TaskSelector.SelectionContext context, ProjectState targetProject, String taskName, boolean includeSubprojects) {
        if (!includeSubprojects) {
            this.configurer.configure(targetProject.getMutableModel());
        } else {
            this.configurer.configureHierarchy(targetProject.getMutableModel());
        }
        TaskSelectionResult tasks = this.taskNameResolver.selectWithName(taskName, targetProject.getMutableModel(), includeSubprojects);
        if (tasks != null) {
            LOGGER.info("Task name matched '{}'", (Object)taskName);
            return new TaskSelection(targetProject.getProjectPath().getPath(), taskName, tasks);
        }
        NameMatcher matcher = new NameMatcher();
        Map<String, TaskSelectionResult> tasksByName = this.taskNameResolver.selectAll(targetProject.getMutableModel(), includeSubprojects);
        String actualName = matcher.find(taskName, tasksByName.keySet());
        if (actualName == null) {
            throw this.throwTaskSelectionException(context, targetProject, taskName, includeSubprojects, matcher);
        }
        LOGGER.info("Abbreviated task name '{}' matched '{}'", (Object)taskName, (Object)actualName);
        return new TaskSelection(targetProject.getProjectPath().getPath(), taskName, tasksByName.get(actualName));
    }

    private RuntimeException throwTaskSelectionException(TaskSelector.SelectionContext context, ProjectState targetProject, String taskName, boolean includeSubprojects, NameMatcher matcher) {
        String searchContext = DefaultTaskSelector.getSearchContext(targetProject, includeSubprojects);
        if (context.getOriginalPath().getPath().equals(taskName)) {
            String message = matcher.formatErrorMessage("Task", searchContext);
            throw this.getProblemsService().getInternalReporter().throwing((Throwable)((Object)new TaskSelectionException(message)), matcher.problemId(), spec -> {
                DefaultTaskSelector.configureProblem(spec, context);
                spec.contextualLabel(message);
            });
        }
        String message = String.format("Cannot locate %s that match '%s' as %s", context.getType(), context.getOriginalPath(), matcher.formatErrorMessage("task", searchContext));
        throw this.getProblemsService().getInternalReporter().throwing((Throwable)((Object)new TaskSelectionException(message)), matcher.problemId(), spec -> DefaultTaskSelector.configureProblem(spec, context).contextualLabel(message));
    }

    private static ProblemSpec configureProblem(ProblemSpec spec, TaskSelector.SelectionContext context) {
        ((InternalProblemSpec)spec).additionalDataInternal(GeneralDataSpec.class, data -> data.put("requestedPath", Objects.requireNonNull(context.getOriginalPath().getPath())));
        spec.severity(Severity.ERROR);
        return spec;
    }

    private static @NonNull String getSearchContext(ProjectState targetProject, boolean includeSubprojects) {
        if (includeSubprojects && !targetProject.getChildProjects().isEmpty()) {
            return targetProject.getDisplayName() + " and its subprojects";
        }
        return targetProject.getDisplayName().getDisplayName();
    }

    private static class TaskPathSpec
    implements Spec<Task> {
        private final ProjectInternal targetProject;
        private final String taskName;

        public TaskPathSpec(ProjectInternal targetProject, String taskName) {
            this.targetProject = targetProject;
            this.taskName = taskName;
        }

        public boolean isSatisfiedBy(Task element) {
            if (!element.getName().equals(this.taskName)) {
                return true;
            }
            for (Project current = element.getProject(); current != null; current = current.getParent()) {
                if (!current.equals(this.targetProject)) continue;
                return false;
            }
            return true;
        }
    }
}

