/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.build.NestedRootBuildRunner;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.Nullable;

@DisableCachingByDefault(because="Child Gradle build will do its own caching")
public abstract class GradleBuild
extends ConventionTask {
    private StartParameter startParameter = NestedRootBuildRunner.createStartParameterForNewBuild(this.getServices());
    private String buildName;

    public GradleBuild() {
        this.startParameter.setCurrentDir(this.getProject().getProjectDir());
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public File getDir() {
        return this.getStartParameter().getCurrentDir();
    }

    public void setDir(File dir) {
        this.setDir((Object)dir);
    }

    public void setDir(Object dir) {
        this.getStartParameter().setCurrentDir(this.getProject().file(dir));
    }

    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFile
    @Deprecated
    public @Nullable File getBuildFile() {
        this.logBuildFileDeprecation();
        return (File)DeprecationLogger.whileDisabled(() -> this.getStartParameter().getBuildFile());
    }

    @Deprecated
    public void setBuildFile(@Nullable File file) {
        this.setBuildFile((Object)file);
    }

    @Deprecated
    public void setBuildFile(@Nullable Object file) {
        this.logBuildFileDeprecation();
        DeprecationLogger.whileDisabled(() -> this.getStartParameter().setBuildFile(this.getProject().file(file)));
    }

    private void logBuildFileDeprecation() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateProperty)((DeprecationMessageBuilder.DeprecateProperty)((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(GradleBuild.class, (String)"buildFile").withContext("Setting custom build file to select the root of the nested build has been deprecated.")).withAdvice("Please use 'dir' to specify the root of the nested build instead.")).replaceWith((Object)"dir")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "configuring_custom_build_layout")).nagUser();
    }

    @Input
    @ToBeReplacedByLazyProperty
    public List<String> getTasks() {
        return this.getStartParameter().getTaskNames();
    }

    public void setTasks(List<String> tasks) {
        this.setTasks((Collection<String>)tasks);
    }

    public void setTasks(Collection<String> tasks) {
        this.getStartParameter().setTaskNames(tasks);
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    @TaskAction
    void build() {
        NestedRootBuildRunner.runNestedRootBuild(this.buildName, (StartParameterInternal)this.getStartParameter(), this.getServices());
    }
}

