/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Collection;
import java.util.function.Consumer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.internal.BuildServiceDetails;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.api.services.internal.ServiceLifecycleException;
import org.gradle.internal.Try;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.collect.PersistentList;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public class RegisteredBuildServiceProvider<T extends BuildService<P>, P extends BuildServiceParameters>
extends BuildServiceProvider<T, P> {
    protected final ServiceRegistry internalServices;
    protected final BuildServiceDetails<T, P> serviceDetails;
    private final IsolationScheme<BuildService<?>, BuildServiceParameters> isolationScheme;
    private final InstantiationScheme instantiationScheme;
    private final IsolatableFactory isolatableFactory;
    private final BuildServiceProvider.Listener listener;
    private final Object instanceLock = new Object();
    @GuardedBy(value="instanceLock")
    private @Nullable Try<T> instance;
    @GuardedBy(value="instanceLock")
    private PersistentList<Consumer<? super RegisteredBuildServiceProvider<T, P>>> stopActions = PersistentList.of();
    private boolean keepAlive;

    public RegisteredBuildServiceProvider(BuildIdentifier buildIdentifier, String name, Class<T> implementationType, @Nullable P parameters, IsolationScheme<BuildService<?>, BuildServiceParameters> isolationScheme, InstantiationScheme instantiationScheme, IsolatableFactory isolatableFactory, ServiceRegistry internalServices, BuildServiceProvider.Listener listener, @Nullable Integer maxUsages) {
        this.serviceDetails = new BuildServiceDetails<T, P>(buildIdentifier, name, implementationType, parameters, maxUsages);
        this.internalServices = internalServices;
        this.isolationScheme = isolationScheme;
        this.instantiationScheme = instantiationScheme;
        this.isolatableFactory = isolatableFactory;
        this.listener = listener;
    }

    @Override
    public BuildServiceDetails<T, P> getServiceDetails() {
        return this.serviceDetails;
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.serviceDetails.getBuildIdentifier();
    }

    @Override
    public String getName() {
        return this.serviceDetails.getName();
    }

    public Class<T> getImplementationType() {
        return this.serviceDetails.getImplementationType();
    }

    public @Nullable P getParameters() {
        return this.serviceDetails.getParameters();
    }

    @Override
    @NullMarked
    public Class<T> getType() {
        return this.serviceDetails.getImplementationType();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void keepAlive() {
        this.keepAlive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeStopping(Consumer<? super RegisteredBuildServiceProvider<T, P>> stopAction) {
        Object object = this.instanceLock;
        synchronized (object) {
            this.stopActions = this.stopActions.plus(stopAction);
        }
    }

    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        return ValueSupplier.Value.of(this.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getInstance() {
        this.listener.beforeGet(this);
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.instance == null) {
                this.instance = this.instantiate();
            }
            return (T)((BuildService)this.instance.get());
        }
    }

    private Try<T> instantiate() {
        BuildServiceParameters isolatedParameters = (BuildServiceParameters)this.isolatableFactory.isolate(this.getParameters()).isolate();
        ServiceLookup instantiationServices = this.instantiationServicesFor(isolatedParameters);
        try {
            return Try.successful(this.instantiate(instantiationServices));
        }
        catch (Exception e) {
            return Try.failure((Throwable)((Object)this.instantiationException(e)));
        }
    }

    private ServiceLifecycleException instantiationException(Exception e) {
        return new ServiceLifecycleException("Failed to create service '" + this.getName() + "'.", e);
    }

    private T instantiate(ServiceLookup instantiationServices) {
        return (T)((BuildService)this.instantiationScheme.withServices(instantiationServices).instantiator().newInstance(this.getImplementationType(), new Object[0]));
    }

    private ServiceLookup instantiationServicesFor(@Nullable P isolatedParameters) {
        return this.isolationScheme.servicesForImplementation(isolatedParameters, (ServiceLookup)this.internalServices, (Collection)ImmutableList.of(), serviceType -> false);
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        return ValueSupplier.ExecutionTimeValue.changingValue((ProviderInternal)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Consumer<? super RegisteredBuildServiceProvider<T, P>>> getStopActions() {
        Object object = this.instanceLock;
        synchronized (object) {
            return this.stopActions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeStop() {
        ExecutionResult<Void> stopResult = ExecutionResult.forEach(this.getStopActions(), action -> action.accept(this));
        Object object = this.instanceLock;
        synchronized (object) {
            try {
                if (this.instance != null) {
                    this.instance.ifSuccessful(t -> {
                        if (t instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)t).close();
                            }
                            catch (Exception e) {
                                ServiceLifecycleException failure = new ServiceLifecycleException("Failed to stop service '" + this.getName() + "'.", e);
                                stopResult.getFailures().forEach(arg_0 -> failure.addSuppressed(arg_0));
                                throw failure;
                            }
                        }
                    });
                }
                stopResult.rethrow();
            }
            finally {
                this.instance = null;
            }
        }
    }

    public ProviderInternal<T> withFinalValue(ValueSupplier.ValueConsumer consumer) {
        return this;
    }

    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return true;
    }
}

