/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.project.taskfactory.TaskIdentityFactory;
import org.gradle.api.internal.project.taskfactory.TaskInstantiator;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.DefaultRealizableTaskCollection;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.RealizeTaskBuildOperationType;
import org.gradle.api.internal.tasks.RegisterTaskBuildOperationType;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskStatistics;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.Transformers;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.metaobject.ConfigureDelegate;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.Path;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private static final Object[] NO_ARGS = new Object[0];
    public static final String EAGERLY_CREATE_LAZY_TASKS_PROPERTY = "org.gradle.internal.tasks.eager";
    private static final Set<String> VALID_TASK_ARGUMENTS = ImmutableSet.of((Object)"action", (Object)"dependsOn", (Object)"description", (Object)"group", (Object)"name", (Object)"overwrite", (Object[])new String[]{"type", "constructorArgs"});
    private static final Set<String> MANDATORY_TASK_ARGUMENTS = ImmutableSet.of((Object)"name", (Object)"type");
    private final TaskIdentityFactory taskIdentityFactory;
    private final ITaskFactory taskFactory;
    private final NamedEntityInstantiator<Task> taskInstantiator;
    private final BuildOperationRunner buildOperationRunner;
    private final ProjectRegistry<ProjectInternal> projectRegistry;
    private final TaskStatistics statistics;
    private final boolean eagerlyCreateLazyTasks;
    private MutableModelNode modelNode;
    private static final RegisterTaskBuildOperationType.Result REGISTER_RESULT = new RegisterTaskBuildOperationType.Result(){};
    private static final RealizeTaskBuildOperationType.Result REALIZE_RESULT = new RealizeTaskBuildOperationType.Result(){};

    public DefaultTaskContainer(ProjectInternal project, Instantiator instantiator, TaskIdentityFactory taskIdentityFactory, ITaskFactory taskFactory, TaskStatistics statistics, BuildOperationRunner buildOperationRunner, CrossProjectConfigurator crossProjectConfigurator, CollectionCallbackActionDecorator callbackDecorator, ProjectRegistry<ProjectInternal> projectRegistry) {
        super(Task.class, instantiator, project, crossProjectConfigurator.getLazyBehaviorGuard(), callbackDecorator);
        this.taskIdentityFactory = taskIdentityFactory;
        this.taskFactory = taskFactory;
        this.taskInstantiator = new TaskInstantiator(taskIdentityFactory, taskFactory, project);
        this.statistics = statistics;
        this.eagerlyCreateLazyTasks = Boolean.getBoolean(EAGERLY_CREATE_LAZY_TASKS_PROPERTY);
        this.buildOperationRunner = buildOperationRunner;
        this.projectRegistry = projectRegistry;
    }

    @Deprecated
    public Task create(Map<String, ?> options) {
        this.assertCanMutate("create(Map)");
        return this.doCreate(options, (Action<? super Task>)Actions.doNothing());
    }

    private Task doCreate(Map<String, ?> options, final Action<? super Task> configureAction) {
        boolean replace;
        Map<String, ?> factoryOptions = options;
        if (options.containsKey("overwrite")) {
            factoryOptions = new HashMap(options);
            Object replaceStr = factoryOptions.remove("overwrite");
            replace = "true".equals(replaceStr.toString());
        } else {
            replace = false;
        }
        final Map<String, ?> actualArgs = DefaultTaskContainer.checkTaskArgsAndCreateDefaultValues(factoryOptions);
        final String name = actualArgs.get("name").toString();
        if (!GUtil.isTrue((Object)name)) {
            throw new InvalidUserDataException("The task name must be provided.");
        }
        final Class type = Objects.requireNonNull((Class)Cast.uncheckedCast(actualArgs.get("type")), "Task type must not be null");
        final TaskIdentity identity = this.taskIdentityFactory.create(name, type, this.project);
        return (Task)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<Task>(){

            public BuildOperationDescriptor.Builder description() {
                return DefaultTaskContainer.realizeDescriptor(identity, replace, true);
            }

            public Task call(BuildOperationContext context) {
                try {
                    Object action;
                    Object group;
                    Object description;
                    Object[] constructorArgs = DefaultTaskContainer.getConstructorArgs(actualArgs);
                    TaskInternal task = (TaskInternal)DefaultTaskContainer.this.createTask(identity, constructorArgs);
                    DefaultTaskContainer.this.statistics.eagerTask(type);
                    Object dependsOnTasks = actualArgs.get("dependsOn");
                    if (dependsOnTasks != null) {
                        task.dependsOn(new Object[]{dependsOnTasks});
                    }
                    if ((description = actualArgs.get("description")) != null) {
                        task.setDescription(description.toString());
                    }
                    if ((group = actualArgs.get("group")) != null) {
                        task.setGroup(group.toString());
                    }
                    if ((action = actualArgs.get("action")) instanceof Action) {
                        Action taskAction = (Action)Cast.uncheckedCast(action);
                        task.doFirst(taskAction);
                    } else if (action != null) {
                        Closure closure = (Closure)action;
                        task.doFirst(closure);
                    }
                    DefaultTaskContainer.this.addTask(task, replace);
                    configureAction.execute((Object)task);
                    context.setResult((Object)REALIZE_RESULT);
                    return task;
                }
                catch (Throwable t) {
                    throw DefaultTaskContainer.this.taskCreationException(name, t);
                }
            }
        });
    }

    private static Object[] getConstructorArgs(Map<String, ?> args) {
        Object constructorArgs = args.get("constructorArgs");
        if (constructorArgs instanceof List) {
            List asList = (List)constructorArgs;
            return asList.toArray();
        }
        if (constructorArgs instanceof Object[]) {
            return (Object[])constructorArgs;
        }
        if (constructorArgs != null) {
            throw new IllegalArgumentException(String.format("%s must be a List or Object[].  Received %s", "constructorArgs", constructorArgs.getClass()));
        }
        return NO_ARGS;
    }

    private static Map<String, ?> checkTaskArgsAndCreateDefaultValues(Map<String, ?> args) {
        DefaultTaskContainer.validateArgs(args);
        if (!args.keySet().containsAll(MANDATORY_TASK_ARGUMENTS)) {
            HashMap argsWithDefaults = new HashMap(args);
            argsWithDefaults.putIfAbsent("name", "");
            argsWithDefaults.putIfAbsent("type", DefaultTask.class);
            return argsWithDefaults;
        }
        return args;
    }

    private static void validateArgs(Map<String, ?> args) {
        if (!VALID_TASK_ARGUMENTS.containsAll(args.keySet())) {
            HashMap unknownArguments = new HashMap(args);
            unknownArguments.keySet().removeAll(VALID_TASK_ARGUMENTS);
            throw new InvalidUserDataException(String.format("Could not create task '%s': Unknown argument(s) in task definition: %s", args.get("name"), unknownArguments.keySet()));
        }
    }

    private <T extends Task> void addTask(T task, boolean replaceExisting) {
        String name = task.getName();
        if (replaceExisting) {
            Task existing = (Task)this.findByNameWithoutRules(name);
            if (existing != null) {
                throw new IllegalStateException("Replacing an existing task that may have already been used by other plugins is not supported.  Use a different name for this task ('" + name + "').");
            }
            TaskCreatingProvider taskProvider = (TaskCreatingProvider)((Object)Cast.uncheckedCast(this.findByNameLaterWithoutRules(name)));
            if (taskProvider != null) {
                this.removeInternal((Object)taskProvider);
                if (!taskProvider.getType().isAssignableFrom(task.getClass())) {
                    throw new IllegalStateException("Replacing an existing task with an incompatible type is not supported.  Use a different name for this task ('" + name + "') or use a compatible type (" + ((TaskInternal)task).getTaskIdentity().type.getName() + ")");
                }
                Action onCreate = (Action)Cast.uncheckedCast((Object)taskProvider.getOnCreateActions().mergeFrom(this.getEventRegister().getAddActions()));
                this.doAdd(task, onCreate);
                return;
            }
            throw new IllegalStateException("Unnecessarily replacing a task that does not exist is not supported.  Use create() or register() directly instead.  You attempted to replace a task named '" + name + "', but there is no existing task with that name.");
        }
        if (this.hasWithName(name)) {
            DefaultTaskContainer.failOnDuplicateTask(name);
        }
        this.addInternal(task);
    }

    private static void failOnDuplicateTask(String task) {
        throw new DuplicateTaskException(String.format("Cannot add task '%s' as a task with that name already exists.", task));
    }

    public <U extends Task> U maybeCreate(String name, Class<U> type) throws InvalidUserDataException {
        Task existing = this.findByName(name);
        if (existing != null) {
            return (U)((Task)Transformers.cast(type).transform((Object)existing));
        }
        return this.create(name, type);
    }

    @Deprecated
    public Task create(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        this.assertCanMutate("create(Map, Closure)");
        return this.doCreate(options, (Action<? super Task>)ConfigureUtil.configureUsing((Closure)configureClosure));
    }

    @Deprecated
    public <T extends Task> T create(String name, Class<T> type) {
        this.assertCanMutate("create(String, Class)");
        return this.doCreate(name, type, NO_ARGS, Actions.doNothing());
    }

    @Deprecated
    public <T extends Task> T create(String name, Class<T> type, Object ... constructorArgs) throws InvalidUserDataException {
        this.assertCanMutate("create(String, Class, Object...)");
        return this.doCreate(name, type, constructorArgs, Actions.doNothing());
    }

    private <T extends Task> T doCreate(String name, Class<T> type, @Nullable Object[] constructorArgs, Action<? super T> configureAction) throws InvalidUserDataException {
        return this.doCreate(this.taskIdentityFactory.create(name, type, this.project), constructorArgs, configureAction);
    }

    private <T extends Task> T doCreate(final TaskIdentity<T> identity, final @Nullable Object[] constructorArgs, final Action<? super T> configureAction) throws InvalidUserDataException {
        return (T)((Task)this.buildOperationRunner.call(new CallableBuildOperation<T>(){

            public T call(BuildOperationContext context) {
                try {
                    Task task = DefaultTaskContainer.this.createTask(identity, constructorArgs);
                    DefaultTaskContainer.this.statistics.eagerTask(identity.type);
                    DefaultTaskContainer.this.addTask(task, false);
                    configureAction.execute((Object)task);
                    context.setResult((Object)REALIZE_RESULT);
                    return task;
                }
                catch (Throwable t) {
                    throw DefaultTaskContainer.this.taskCreationException(identity.name, t);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                return DefaultTaskContainer.realizeDescriptor(identity, false, true);
            }
        }));
    }

    private <T extends Task> T createTask(TaskIdentity<T> identity, @Nullable Object[] constructorArgs) throws InvalidUserDataException {
        if (constructorArgs != null) {
            for (int i = 0; i < constructorArgs.length; ++i) {
                if (constructorArgs[i] != null) continue;
                throw new NullPointerException(String.format("Received null for %s constructor argument #%s", identity.type.getName(), i + 1));
            }
        }
        return this.taskFactory.create(identity, constructorArgs);
    }

    @Deprecated
    public Task create(String name) {
        this.assertCanMutate("create(String)");
        return this.doCreate(name, DefaultTask.class, NO_ARGS, Actions.doNothing());
    }

    @Deprecated
    public Task create(String name, Action<? super Task> configureAction) throws InvalidUserDataException {
        this.assertCanMutate("create(String, Action)");
        return this.doCreate(name, DefaultTask.class, NO_ARGS, configureAction);
    }

    public Task maybeCreate(String name) {
        Task task = this.findByName(name);
        if (task != null) {
            return task;
        }
        return this.create(name);
    }

    public Task replace(String name) {
        this.assertCanMutate("replace(String)");
        return this.replace(name, DefaultTask.class);
    }

    @Deprecated
    public Task create(String name, Closure configureClosure) {
        this.assertCanMutate("create(String, Closure)");
        return this.doCreate(name, DefaultTask.class, NO_ARGS, ConfigureUtil.configureUsing((Closure)configureClosure));
    }

    @Deprecated
    public <T extends Task> T create(String name, Class<T> type, Action<? super T> configuration) throws InvalidUserDataException {
        this.assertCanMutate("create(String, Class, Action)");
        T task = this.create(name, type);
        configuration.execute(task);
        return task;
    }

    public TaskProvider<Task> register(String name, Action<? super Task> configurationAction) throws InvalidUserDataException {
        this.assertCanMutate("register(String, Action)");
        return (TaskProvider)Cast.uncheckedCast(this.register(name, (Class<T>)DefaultTask.class, (Action<? super T>)((Action)configurationAction)));
    }

    public <T extends Task> TaskProvider<T> register(String name, Class<T> type, Action<? super T> configurationAction) throws InvalidUserDataException {
        this.assertCanMutate("register(String, Class, Action)");
        return this.registerTask(name, type, configurationAction, NO_ARGS);
    }

    public <T extends Task> TaskProvider<T> register(String name, Class<T> type) throws InvalidUserDataException {
        this.assertCanMutate("register(String, Class)");
        return this.register(name, type, NO_ARGS);
    }

    public TaskProvider<Task> register(String name) throws InvalidUserDataException {
        this.assertCanMutate("register(String)");
        return (TaskProvider)Cast.uncheckedCast(this.register(name, DefaultTask.class));
    }

    public <T extends Task> TaskProvider<T> register(String name, Class<T> type, Object ... constructorArgs) {
        this.assertCanMutate("register(String, Class, Object...)");
        return this.registerTask(name, type, null, constructorArgs);
    }

    private <T extends Task> TaskProvider<T> registerTask(String name, Class<T> type, final @Nullable Action<? super T> configurationAction, final Object ... constructorArgs) {
        if (this.hasWithName(name)) {
            DefaultTaskContainer.failOnDuplicateTask(name);
        }
        final TaskIdentity<T> identity = this.taskIdentityFactory.create(name, type, this.project);
        TaskProvider provider = (TaskProvider)this.buildOperationRunner.call(new CallableBuildOperation<TaskProvider<T>>(){

            public BuildOperationDescriptor.Builder description() {
                return DefaultTaskContainer.registerDescriptor(identity);
            }

            public TaskProvider<T> call(BuildOperationContext context) {
                TaskProvider provider = (TaskProvider)Cast.uncheckedNonnullCast((Object)DefaultTaskContainer.this.getInstantiator().newInstance(TaskCreatingProvider.class, new Object[]{DefaultTaskContainer.this, identity, configurationAction, constructorArgs}));
                DefaultTaskContainer.this.addLaterInternal((Provider<? extends Task>)((Provider)provider));
                context.setResult((Object)REGISTER_RESULT);
                return provider;
            }
        });
        if (this.eagerlyCreateLazyTasks) {
            provider.get();
        }
        return provider;
    }

    public <T extends Task> T replace(final String name, Class<T> type) {
        this.assertCanMutate("replace(String, Class)");
        final TaskIdentity<T> identity = this.taskIdentityFactory.create(name, type, this.project);
        return (T)((Task)this.buildOperationRunner.call(new CallableBuildOperation<T>(){

            public T call(BuildOperationContext context) {
                try {
                    Object task = DefaultTaskContainer.this.taskFactory.create(identity, NO_ARGS);
                    DefaultTaskContainer.this.addTask(task, true);
                    context.setResult((Object)REALIZE_RESULT);
                    return task;
                }
                catch (Throwable t) {
                    throw DefaultTaskContainer.this.taskCreationException(name, t);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                return DefaultTaskContainer.realizeDescriptor(identity, true, true);
            }
        }));
    }

    @Override
    public <T extends Task> T createWithoutConstructor(String name, Class<T> type, long uniqueId) {
        this.assertCanMutate("createWithoutConstructor(String, Class, Object...)");
        return this.doCreate(this.taskIdentityFactory.recreate(name, type, this.project, uniqueId), null, Actions.doNothing());
    }

    public Task findByPath(String path) {
        Path.validatePath((String)path);
        if (!path.contains(":")) {
            return this.findByName(path);
        }
        String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
        String projectPathOrRoot = Strings.isNullOrEmpty((String)projectPath) ? ":" : projectPath;
        ProjectInternal project = this.projectRegistry.getProject(this.project.absoluteProjectPath(projectPathOrRoot));
        if (project == null) {
            return null;
        }
        project.getOwner().ensureTasksDiscovered();
        return (Task)project.getTasks().findByName(StringUtils.substringAfterLast((String)path, (String)":"));
    }

    public Task resolveTask(String path) {
        return this.getByPath(path);
    }

    public Task getByPath(String path) throws UnknownTaskException {
        Task task = this.findByPath(path);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", path, this.project));
        }
        return task;
    }

    public TaskContainerInternal configure(Closure configureClosure) {
        return (TaskContainerInternal)ConfigureUtil.configureSelf((Closure)configureClosure, (Object)this, (ConfigureDelegate)new NamedDomainObjectContainerConfigureDelegate((Closure<?>)configureClosure, (NamedDomainObjectContainer<?>)this));
    }

    @Override
    public NamedEntityInstantiator<Task> getEntityInstantiator() {
        return this.taskInstantiator;
    }

    @Override
    public DynamicObject getTasksAsDynamicObject() {
        return this.getElementsAsDynamicObject();
    }

    @Override
    public SortedSet<String> getNames() {
        SortedSet<String> names = super.getNames();
        if (this.modelNode == null) {
            return names;
        }
        TreeSet<String> allNames = new TreeSet<String>(names);
        allNames.addAll(this.modelNode.getLinkNames());
        return allNames;
    }

    @Override
    public void realize() {
        if (this.modelNode != null) {
            this.project.getModelRegistry().realizeNode(this.modelNode.getPath());
        }
    }

    @Override
    public void discoverTasks() {
        this.project.fireDeferredConfiguration();
        if (this.modelNode != null) {
            this.project.getModelRegistry().atStateOrLater(this.modelNode.getPath(), ModelNode.State.SelfClosed);
        }
    }

    @Override
    public void prepareForExecution(Task task) {
        assert (task.getProject() == this.project);
        if (this.modelNode != null && this.modelNode.hasLink(task.getName())) {
            this.realizeTask(MODEL_PATH.child(task.getName()), ModelNode.State.GraphClosed);
        }
    }

    private boolean maybeCreateTasks(String name) {
        if (this.modelNode != null && this.modelNode.hasLink(name)) {
            this.realizeTask(MODEL_PATH.child(name), ModelNode.State.Initialized);
            return true;
        }
        return false;
    }

    @Override
    public Task findByName(String name) {
        Task task = (Task)super.findByName(name);
        if (task != null) {
            return task;
        }
        if (!this.maybeCreateTasks(name)) {
            return null;
        }
        return (Task)super.findByNameWithoutRules(name);
    }

    private void realizeTask(ModelPath taskPath, ModelNode.State minState) {
        this.project.getModelRegistry().atStateOrLater(taskPath, ModelType.of(Task.class), minState);
    }

    public <U extends Task> NamedDomainObjectContainer<U> containerWithType(Class<U> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<? extends Class<? extends Task>> getCreateableTypes() {
        return Collections.singleton(this.getType());
    }

    public void setModelNode(MutableModelNode modelNode) {
        this.modelNode = modelNode;
    }

    @Override
    public <S extends Task> TaskCollection<S> withType(Class<S> type) {
        Instantiator instantiator = this.getInstantiator();
        return (TaskCollection)Cast.uncheckedCast((Object)instantiator.newInstance(DefaultRealizableTaskCollection.class, new Object[]{type, super.withType(type), this.modelNode, instantiator}));
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw DefaultTaskContainer.unsupportedTaskRemovalException();
    }

    private void removeInternal(Object o) {
        super.remove(o);
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw DefaultTaskContainer.unsupportedTaskRemovalException();
    }

    @Override
    public void clear() {
        throw DefaultTaskContainer.unsupportedTaskRemovalException();
    }

    @Override
    public boolean retainAll(Collection<?> target) {
        throw DefaultTaskContainer.unsupportedTaskRemovalException();
    }

    @Override
    public Iterator<Task> iterator() {
        final Iterator delegate = super.iterator();
        return new Iterator<Task>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public Task next() {
                return (Task)delegate.next();
            }

            @Override
            public void remove() {
                throw DefaultTaskContainer.unsupportedTaskRemovalException();
            }
        };
    }

    private static RuntimeException unsupportedTaskRemovalException() {
        return new UnsupportedOperationException("Removing tasks from the task container is not supported.  Disable the tasks or use replace() instead.");
    }

    @Override
    public Action<? super Task> whenObjectRemoved(Action<? super Task> action) {
        throw new UnsupportedOperationException("Registering actions on task removal is not supported.");
    }

    @Override
    public void whenObjectRemoved(Closure action) {
        throw new UnsupportedOperationException("Registering actions on task removal is not supported.");
    }

    private RuntimeException taskCreationException(String name, Throwable cause) {
        if (cause instanceof DuplicateTaskException) {
            return (RuntimeException)cause;
        }
        return new TaskCreationException(String.format("Could not create task '%s'.", this.project.identityPath(name)), cause);
    }

    private static BuildOperationDescriptor.Builder realizeDescriptor(TaskIdentity<?> identity, boolean replacement, boolean eager) {
        return BuildOperationDescriptor.displayName((String)("Realize task " + identity.identityPath)).details((Object)new RealizeDetails(identity, replacement, eager));
    }

    private static BuildOperationDescriptor.Builder registerDescriptor(TaskIdentity<?> identity) {
        return BuildOperationDescriptor.displayName((String)("Register task " + identity.identityPath)).details((Object)new RegisterDetails(identity));
    }

    @Override
    @Deprecated
    public boolean add(Task o) {
        throw new UnsupportedOperationException("Adding a task directly to the task container is not supported.  Use register() instead.");
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends Task> c) {
        throw new UnsupportedOperationException("Adding a collection of tasks directly to the task container is not supported.  Use register() instead.");
    }

    @Override
    public void addLater(Provider<? extends Task> provider) {
        throw new UnsupportedOperationException("Adding a task provider directly to the task container is not supported.  Use the register() method instead.");
    }

    @Override
    public void addAllLater(Provider<? extends Iterable<Task>> provider) {
        throw new UnsupportedOperationException("Adding a task provider directly to the task container is not supported.  Use the register() method instead.");
    }

    @Override
    public boolean addInternal(Task task) {
        return super.add(task);
    }

    @Override
    public boolean addAllInternal(Collection<? extends Task> task) {
        return super.addAll(task);
    }

    private void addLaterInternal(Provider<? extends Task> provider) {
        super.addLater(provider);
    }

    public class TaskCreatingProvider<I extends Task>
    extends DefaultNamedDomainObjectCollection.AbstractDomainObjectCreatingProvider<I>
    implements TaskProvider<I> {
        private final TaskIdentity<I> identity;
        private Object[] constructorArgs;

        public TaskCreatingProvider(@Nullable TaskIdentity<I> identity, Action<? super I> configureAction, Object ... constructorArgs) {
            super(identity.name, identity.type, configureAction);
            this.identity = identity;
            this.constructorArgs = constructorArgs;
            DefaultTaskContainer.this.statistics.lazyTask();
        }

        public ImmutableActionSet<I> getOnCreateActions() {
            return this.onCreate;
        }

        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.taskState((Task)((Task)this.get()));
        }

        @Override
        protected void tryCreate() {
            DefaultTaskContainer.this.buildOperationRunner.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    try {
                        TaskCreatingProvider.super.tryCreate();
                        context.setResult((Object)REALIZE_RESULT);
                    }
                    finally {
                        TaskCreatingProvider.access$1502(TaskCreatingProvider.this, null);
                    }
                }

                public BuildOperationDescriptor.Builder description() {
                    return DefaultTaskContainer.realizeDescriptor(TaskCreatingProvider.this.identity, false, false);
                }
            });
        }

        @Override
        protected I createDomainObject() {
            return (I)DefaultTaskContainer.this.createTask(this.identity, this.constructorArgs);
        }

        @Override
        protected void onLazyDomainObjectRealized() {
            DefaultTaskContainer.this.statistics.lazyTaskRealized(this.getType());
        }

        @Override
        protected RuntimeException domainObjectCreationException(Throwable cause) {
            return DefaultTaskContainer.this.taskCreationException(this.getName(), cause);
        }

        static /* synthetic */ Object[] access$1502(TaskCreatingProvider x0, Object[] x1) {
            x0.constructorArgs = x1;
            return x1;
        }
    }

    private static class DuplicateTaskException
    extends InvalidUserDataException {
        public DuplicateTaskException(String message) {
            super(message);
        }
    }

    @Contextual
    private static class TaskCreationException
    extends GradleException {
        TaskCreationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class RealizeDetails
    implements RealizeTaskBuildOperationType.Details {
        private final TaskIdentity<?> identity;
        private final boolean replacement;
        private final boolean eager;

        RealizeDetails(TaskIdentity<?> identity, boolean replacement, boolean eager) {
            this.identity = identity;
            this.replacement = replacement;
            this.eager = eager;
        }

        public String getBuildPath() {
            return this.identity.buildPath.toString();
        }

        public String getTaskPath() {
            return this.identity.projectPath.toString();
        }

        public long getTaskId() {
            return this.identity.uniqueId;
        }

        public boolean isReplacement() {
            return this.replacement;
        }

        public boolean isEager() {
            return this.eager;
        }
    }

    private static final class RegisterDetails
    implements RegisterTaskBuildOperationType.Details {
        private final TaskIdentity<?> identity;

        RegisterDetails(TaskIdentity<?> identity) {
            this.identity = identity;
        }

        public String getBuildPath() {
            return this.identity.buildPath.toString();
        }

        public String getTaskPath() {
            return this.identity.projectPath.toString();
        }

        public long getTaskId() {
            return this.identity.uniqueId;
        }

        public boolean isReplacement() {
            return false;
        }
    }
}

