/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.cache;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.cache.CacheResourceConfiguration;
import org.gradle.api.cache.Cleanup;
import org.gradle.api.cache.MarkingStrategy;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.internal.cache.CacheResourceConfigurationInternal;
import org.gradle.api.internal.cache.CleanupInternal;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.internal.LegacyCacheCleanupEnablement;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.time.Clock;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class DefaultCacheConfigurations
implements CacheConfigurationsInternal {
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    private static final String RELEASED_WRAPPERS = "releasedWrappers";
    private static final String SNAPSHOT_WRAPPERS = "snapshotWrappers";
    private static final String DOWNLOADED_RESOURCES = "downloadedResources";
    private static final String CREATED_RESOURCES = "createdResources";
    private static final String BUILD_CACHE = "buildCache";
    static final String UNSAFE_MODIFICATION_ERROR = "The property '%s' was modified from an unsafe location (for instance a settings script or plugin).  This property can only be changed in an init script, preferably stored in the init.d directory inside the Gradle user home directory. " + DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("information on this", "directory_layout", "dir:gradle_user_home:configure_cache_cleanup");
    private final CacheResourceConfigurationInternal releasedWrappersConfiguration;
    private final CacheResourceConfigurationInternal snapshotWrappersConfiguration;
    private final CacheResourceConfigurationInternal downloadedResourcesConfiguration;
    private final CacheResourceConfigurationInternal createdResourcesConfiguration;
    private final CacheResourceConfigurationInternal buildCacheConfiguration;
    private final Property<Cleanup> cleanup;
    private final Property<MarkingStrategy> markingStrategy;
    private final LegacyCacheCleanupEnablement legacyCacheCleanupEnablement;
    private boolean cleanupHasBeenConfigured;

    @Inject
    public DefaultCacheConfigurations(ObjectFactory objectFactory, PropertyHost propertyHost, LegacyCacheCleanupEnablement legacyCacheCleanupEnablement, Clock clock) {
        this.releasedWrappersConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, RELEASED_WRAPPERS, clock, 30);
        this.snapshotWrappersConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, SNAPSHOT_WRAPPERS, clock, 7);
        this.downloadedResourcesConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, DOWNLOADED_RESOURCES, clock, 30);
        this.createdResourcesConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, CREATED_RESOURCES, clock, 7);
        this.buildCacheConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, BUILD_CACHE, clock, 7);
        this.cleanup = new ContextualErrorMessageProperty<Cleanup>(propertyHost, Cleanup.class, "cleanup").convention(this.createCleanupConvention());
        this.markingStrategy = new ContextualErrorMessageProperty<MarkingStrategy>(propertyHost, MarkingStrategy.class, "markingStrategy").convention(MarkingStrategy.CACHEDIR_TAG);
        this.legacyCacheCleanupEnablement = legacyCacheCleanupEnablement;
    }

    private static CacheResourceConfigurationInternal createResourceConfiguration(ObjectFactory objectFactory, String name, Clock clock, int defaultDays) {
        CacheResourceConfigurationInternal resourceConfiguration = (CacheResourceConfigurationInternal)objectFactory.newInstance(DefaultCacheResourceConfiguration.class, new Object[]{name, clock});
        resourceConfiguration.getEntryRetention().convention((Object)CacheResourceConfigurationInternal.EntryRetention.relative((long)TimeUnit.DAYS.toMillis(defaultDays)));
        return resourceConfiguration;
    }

    private Provider<Cleanup> createCleanupConvention() {
        return DefaultCacheConfigurations.providerFromSupplier(() -> this.legacyCacheCleanupEnablement.isDisabledByProperty() ? Cleanup.DISABLED : Cleanup.DEFAULT);
    }

    public void releasedWrappers(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute((Object)this.releasedWrappersConfiguration);
    }

    public CacheResourceConfigurationInternal getReleasedWrappers() {
        return this.releasedWrappersConfiguration;
    }

    public void snapshotWrappers(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute((Object)this.snapshotWrappersConfiguration);
    }

    public CacheResourceConfigurationInternal getSnapshotWrappers() {
        return this.snapshotWrappersConfiguration;
    }

    public void downloadedResources(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute((Object)this.downloadedResourcesConfiguration);
    }

    public CacheResourceConfigurationInternal getDownloadedResources() {
        return this.downloadedResourcesConfiguration;
    }

    public void createdResources(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute((Object)this.createdResourcesConfiguration);
    }

    public CacheResourceConfigurationInternal getCreatedResources() {
        return this.createdResourcesConfiguration;
    }

    public void buildCache(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute((Object)this.buildCacheConfiguration);
    }

    public CacheResourceConfigurationInternal getBuildCache() {
        return this.buildCacheConfiguration;
    }

    public Property<Cleanup> getCleanup() {
        return this.cleanup;
    }

    public Property<MarkingStrategy> getMarkingStrategy() {
        return this.markingStrategy;
    }

    public Provider<CleanupFrequency> getCleanupFrequency() {
        return this.getCleanup().map(cleanup -> new MustBeConfiguredCleanupFrequency(((CleanupInternal)cleanup).getCleanupFrequency()));
    }

    public void synchronize(CacheConfigurationsInternal persistentCacheConfigurations) {
        persistentCacheConfigurations.getReleasedWrappers().getEntryRetention().value((Provider)this.getReleasedWrappers().getEntryRetention());
        persistentCacheConfigurations.getSnapshotWrappers().getEntryRetention().value((Provider)this.getSnapshotWrappers().getEntryRetention());
        persistentCacheConfigurations.getDownloadedResources().getEntryRetention().value((Provider)this.getDownloadedResources().getEntryRetention());
        persistentCacheConfigurations.getCreatedResources().getEntryRetention().value((Provider)this.getCreatedResources().getEntryRetention());
        persistentCacheConfigurations.getBuildCache().getEntryRetention().value((Provider)this.getBuildCache().getEntryRetention());
        persistentCacheConfigurations.getCleanup().value(this.getCleanup());
        persistentCacheConfigurations.getMarkingStrategy().value(this.getMarkingStrategy());
    }

    public void finalizeConfiguration(Gradle gradle) {
        this.finalizeConfigurationValues();
        this.markCacheDirectories(gradle);
    }

    @VisibleForTesting
    void finalizeConfigurationValues() {
        this.releasedWrappersConfiguration.getEntryRetention().finalizeValue();
        this.snapshotWrappersConfiguration.getEntryRetention().finalizeValue();
        this.downloadedResourcesConfiguration.getEntryRetention().finalizeValue();
        this.createdResourcesConfiguration.getEntryRetention().finalizeValue();
        this.buildCacheConfiguration.getEntryRetention().finalizeValue();
        this.getCleanup().finalizeValue();
        this.getMarkingStrategy().finalizeValue();
    }

    private void markCacheDirectories(Gradle gradle) {
        MarkingStrategy strategy = (MarkingStrategy)this.getMarkingStrategy().get();
        strategy.tryMarkCacheDirectory(new File(gradle.getGradleUserHomeDir(), "wrapper/dists"));
        strategy.tryMarkCacheDirectory(new File(gradle.getGradleUserHomeDir(), "daemon"));
        strategy.tryMarkCacheDirectory(new File(gradle.getGradleUserHomeDir(), "caches"));
        strategy.tryMarkCacheDirectory(new File(gradle.getGradleUserHomeDir(), "jdks"));
    }

    public void setCleanupHasBeenConfigured(boolean hasBeenConfigured) {
        this.cleanupHasBeenConfigured = hasBeenConfigured;
    }

    private static <T> Provider<T> providerFromSupplier(Supplier<T> supplier) {
        return new DefaultProvider(supplier::get);
    }

    private static class ContextualErrorMessageProperty<T>
    extends DefaultProperty<T> {
        private final String displayName;

        public ContextualErrorMessageProperty(PropertyHost propertyHost, Class<T> type, String displayName) {
            super(propertyHost, type);
            this.displayName = displayName;
        }

        private IllegalStateException alreadyFinalizedError() {
            return new IllegalStateException(String.format(UNSAFE_MODIFICATION_ERROR, this.getDisplayName()));
        }

        private void onlyIfMutable(Runnable runnable) {
            if (this.isFinalized()) {
                throw this.alreadyFinalizedError();
            }
            runnable.run();
        }

        protected @NonNull DisplayName getDisplayName() {
            if (this.displayName != null) {
                return Describables.of((Object)this.displayName);
            }
            return super.getDisplayName();
        }

        public void set(@Nullable T value) {
            this.onlyIfMutable(() -> super.set(value));
        }

        public void set(Provider<? extends T> provider) {
            this.onlyIfMutable(() -> super.set(provider));
        }

        public ContextualErrorMessageProperty<T> value(@Nullable T value) {
            this.onlyIfMutable(() -> super.value(value));
            return this;
        }

        public ContextualErrorMessageProperty<T> value(Provider<? extends T> provider) {
            this.onlyIfMutable(() -> super.value(provider));
            return this;
        }

        public ContextualErrorMessageProperty<T> convention(@Nullable T value) {
            this.onlyIfMutable(() -> super.convention(value));
            return this;
        }

        public ContextualErrorMessageProperty<T> convention(Provider<? extends T> provider) {
            this.onlyIfMutable(() -> super.convention(provider));
            return this;
        }
    }

    static abstract class DefaultCacheResourceConfiguration
    implements CacheResourceConfigurationInternal {
        private final String name;
        private final Clock clock;
        private final Property<CacheResourceConfigurationInternal.EntryRetention> entryRetention;

        @Inject
        public DefaultCacheResourceConfiguration(PropertyHost propertyHost, String name, Clock clock) {
            this.name = name;
            this.clock = clock;
            this.entryRetention = new ContextualErrorMessageProperty<CacheResourceConfigurationInternal.EntryRetention>(propertyHost, CacheResourceConfigurationInternal.EntryRetention.class, "entryRetention");
        }

        public Property<CacheResourceConfigurationInternal.EntryRetention> getEntryRetention() {
            return this.entryRetention;
        }

        public Supplier<Long> getEntryRetentionTimestampSupplier() {
            return () -> {
                CacheResourceConfigurationInternal.EntryRetention retentionValue = (CacheResourceConfigurationInternal.EntryRetention)this.entryRetention.get();
                if (retentionValue.isRelative()) {
                    return this.clock.getCurrentTime() - retentionValue.getTimeInMillis();
                }
                return retentionValue.getTimeInMillis();
            };
        }

        public void setRemoveUnusedEntriesOlderThan(long timestamp) {
            this.getEntryRetention().set((Object)CacheResourceConfigurationInternal.EntryRetention.absolute((long)timestamp));
        }

        public void setRemoveUnusedEntriesAfterDays(int removeUnusedEntriesAfterDays) {
            if (removeUnusedEntriesAfterDays < 1) {
                throw new IllegalArgumentException(this.name + " cannot be set to retain entries for " + removeUnusedEntriesAfterDays + " days.  For time frames shorter than one day, use the 'removeUnusedEntriesOlderThan' property.");
            }
            long daysInMillis = TimeUnit.DAYS.toMillis(removeUnusedEntriesAfterDays);
            this.getEntryRetention().set((Object)CacheResourceConfigurationInternal.EntryRetention.relative((long)daysInMillis));
        }
    }

    private class MustBeConfiguredCleanupFrequency
    implements CleanupFrequency {
        private final CleanupFrequency configuredCleanupFrequency;

        public MustBeConfiguredCleanupFrequency(CleanupFrequency configuredCleanupFrequency) {
            this.configuredCleanupFrequency = configuredCleanupFrequency;
        }

        public boolean shouldCleanupOnEndOfSession() {
            return this.configuredCleanupFrequency.shouldCleanupOnEndOfSession();
        }

        public boolean requiresCleanup(@Nullable Instant lastCleanupTime) {
            return DefaultCacheConfigurations.this.cleanupHasBeenConfigured && this.configuredCleanupFrequency.requiresCleanup(lastCleanupTime);
        }
    }
}

