/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AbstractAttributeContainer;
import org.gradle.api.internal.attributes.AttributeValueIsolator;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.provider.MappingProvider;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;
import org.jspecify.annotations.Nullable;

public final class DefaultMutableAttributeContainer
extends AbstractAttributeContainer {
    private final AttributesFactory attributesFactory;
    private final AttributeValueIsolator attributeValueIsolator;
    private final MapProperty<Attribute<?>, Isolatable<?>> state;
    private boolean realizingLazyState;

    public DefaultMutableAttributeContainer(AttributesFactory attributesFactory, AttributeValueIsolator attributeValueIsolator, PropertyFactory propertyFactory) {
        this.attributesFactory = attributesFactory;
        this.attributeValueIsolator = attributeValueIsolator;
        this.state = (MapProperty)Cast.uncheckedNonnullCast((Object)propertyFactory.mapProperty(Attribute.class, Isolatable.class));
    }

    public String toString() {
        TreeMap sorted = new TreeMap(Comparator.comparing(Attribute::getName));
        sorted.putAll(this.getRealizedEntries());
        return ((Object)sorted).toString();
    }

    public Set<Attribute<?>> keySet() {
        Set realizedKeys = this.doRealize(s -> (Set)s.keySet().get());
        DefaultMutableAttributeContainer.assertNoDuplicateNames(realizedKeys);
        return realizedKeys;
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        this.checkInsertionAllowed(key);
        this.assertAttributeValueIsNotNull(value);
        this.assertAttributeTypeIsValid(value.getClass(), key);
        this.state.put(key, this.attributeValueIsolator.isolate(value));
        return this;
    }

    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        MappingProvider isolated;
        this.checkInsertionAllowed(key);
        this.assertAttributeValueIsNotNull(provider);
        ProviderInternal providerInternal = (ProviderInternal)Cast.uncheckedCast(provider);
        Class valueType = providerInternal.getType();
        Class typedIsolatable = (Class)Cast.uncheckedCast(Isolatable.class);
        if (valueType != null) {
            this.assertAttributeTypeIsValid(valueType, key);
            isolated = new MappingProvider(typedIsolatable, providerInternal, this.attributeValueIsolator::isolate);
        } else {
            isolated = new MappingProvider(typedIsolatable, providerInternal, t -> {
                this.assertAttributeTypeIsValid(t.getClass(), key);
                return this.attributeValueIsolator.isolate(t);
            });
        }
        this.state.put(key, (Provider)isolated);
        return this;
    }

    private <T> void checkInsertionAllowed(Attribute<T> key) {
        if (this.realizingLazyState) {
            throw new IllegalStateException("Cannot add new attribute '" + key.getName() + "' while realizing all attributes of the container.");
        }
    }

    private Map<Attribute<?>, Isolatable<?>> getRealizedEntries() {
        Map realizedState = this.doRealize(Provider::get);
        DefaultMutableAttributeContainer.assertNoDuplicateNames(realizedState.keySet());
        return realizedState;
    }

    private static void assertNoDuplicateNames(Set<Attribute<?>> attributes) {
        HashMap attributesByName = new HashMap();
        for (Attribute<?> attribute : attributes) {
            String name = attribute.getName();
            Attribute<?> existing = attributesByName.put(name, attribute);
            if (existing == null) continue;
            throw new IllegalStateException("Cannot have two attributes with the same name but different types. This container has an attribute named '" + name + "' of type '" + existing.getType().getName() + "' and another attribute of type '" + attribute.getType().getName() + "'");
        }
    }

    private <T> T doRealize(Function<MapProperty<Attribute<?>, Isolatable<?>>, T> realizeAction) {
        this.realizingLazyState = true;
        try {
            T t = realizeAction.apply(this.state);
            return t;
        }
        finally {
            this.realizingLazyState = false;
        }
    }

    private <T> void assertAttributeTypeIsValid(Class<?> valueType, Attribute<T> attribute) {
        if (!attribute.getType().isAssignableFrom(valueType)) {
            throw new IllegalArgumentException(String.format("Unexpected type for attribute '%s' provided. Expected a value of type %s but found a value of type %s.", attribute.getName(), attribute.getType().getName(), valueType.getName()));
        }
    }

    private void assertAttributeValueIsNotNull(@Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Setting null as an attribute value is not allowed");
        }
    }

    public <T> @Nullable T getAttribute(Attribute<T> key) {
        if (!this.isValidAttributeRequest(key)) {
            return null;
        }
        return (T)Cast.uncheckedCast((Object)this.state.getting(key).map(Isolatable::isolate).getOrNull());
    }

    @Override
    public ImmutableAttributes asImmutable() {
        return this.attributesFactory.fromMap(this.getRealizedEntries());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMutableAttributeContainer that = (DefaultMutableAttributeContainer)o;
        return Objects.equals(this.asImmutable(), that.asImmutable());
    }

    @Override
    public int hashCode() {
        return this.asImmutable().hashCode();
    }
}

