/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.problems.AdditionalData;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.FileLocation;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemLocation;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.AdditionalDataBuilder;
import org.gradle.api.problems.internal.AdditionalDataSpec;
import org.gradle.api.problems.internal.DefaultDocLink;
import org.gradle.api.problems.internal.DefaultFileLocation;
import org.gradle.api.problems.internal.DefaultLineInFileLocation;
import org.gradle.api.problems.internal.DefaultOffsetInFileLocation;
import org.gradle.api.problems.internal.DefaultPluginIdLocation;
import org.gradle.api.problems.internal.DefaultProblem;
import org.gradle.api.problems.internal.DefaultProblemDefinition;
import org.gradle.api.problems.internal.DefaultProblemId;
import org.gradle.api.problems.internal.DefaultStackTraceLocation;
import org.gradle.api.problems.internal.DefaultTaskLocation;
import org.gradle.api.problems.internal.DefaultTypedAdditionalData;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.PluginIdLocation;
import org.gradle.api.problems.internal.ProblemsInfrastructure;
import org.gradle.internal.code.UserCodeSource;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemStream;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class DefaultProblemBuilder
implements InternalProblemBuilder {
    private final ProblemsInfrastructure problemsInfrastructure;
    private ProblemId id;
    private String contextualLabel;
    private Severity severity;
    private final List<ProblemLocation> originLocations = new ArrayList<ProblemLocation>();
    private final List<ProblemLocation> contextLocations = new ArrayList<ProblemLocation>();
    private String details;
    private DocLink docLink;
    private List<String> solutions;
    private Throwable exception;
    private AdditionalData additionalData;
    private boolean collectStackLocation = false;
    private ProblemDiagnostics diagnostics;

    public DefaultProblemBuilder(ProblemsInfrastructure infrastructure) {
        this.problemsInfrastructure = infrastructure;
        this.additionalData = null;
        this.solutions = new ArrayList<String>();
    }

    public DefaultProblemBuilder(InternalProblem problem, ProblemsInfrastructure infrastructure) {
        this(infrastructure);
        this.id = problem.getDefinition().getId();
        this.contextualLabel = problem.getContextualLabel();
        this.solutions = new ArrayList<String>(problem.getSolutions());
        this.severity = problem.getDefinition().getSeverity();
        this.originLocations.addAll(problem.getOriginLocations());
        this.contextLocations.addAll(problem.getContextualLocations());
        this.details = problem.getDetails();
        this.docLink = problem.getDefinition().getDocumentationLink();
        this.exception = problem.getException();
        this.additionalData = problem.getAdditionalData();
    }

    @Override
    public InternalProblem build() {
        if (this.getId() == null) {
            return this.invalidProblem("missing-id", "Problem id must be specified", null);
        }
        if (this.getId().getGroup() == null) {
            return this.invalidProblem("missing-parent", "Problem id must have a parent", null);
        }
        if (this.additionalData instanceof UnsupportedAdditionalDataSpec) {
            return this.invalidProblem("unsupported-additional-data", "Unsupported additional data type", "Unsupported additional data type: " + ((UnsupportedAdditionalDataSpec)this.additionalData).getType().getName() + ". Supported types are: " + this.problemsInfrastructure.getAdditionalDataBuilderFactory().getSupportedTypes());
        }
        ProblemDiagnostics diagnostics = this.determineDiagnostics();
        if (diagnostics != null) {
            this.addLocationsFromDiagnostics(this.collectStackLocation ? this.originLocations : this.contextLocations, diagnostics);
        }
        DefaultProblemDefinition problemDefinition = new DefaultProblemDefinition(this.getId(), this.getSeverity(), this.docLink);
        return new DefaultProblem(problemDefinition, this.contextualLabel, this.solutions, this.originLocations, this.contextLocations, this.details, this.exception, this.additionalData);
    }

    @Nullable
    private ProblemDiagnostics determineDiagnostics() {
        if (this.diagnostics != null) {
            return this.diagnostics;
        }
        ProblemStream problemStream = this.problemsInfrastructure.getProblemStream();
        if (problemStream == null || !this.collectStackLocation && this.areLocationsProvided()) {
            return null;
        }
        return problemStream.forCurrentCaller(this.exceptionForStackLocation(this.severity == Severity.ERROR));
    }

    private boolean areLocationsProvided() {
        return !this.contextLocations.isEmpty() || !this.originLocations.isEmpty();
    }

    private Throwable exceptionForStackLocation(boolean overruleStacktraceLimit) {
        return this.getException() == null && overruleStacktraceLimit ? new RuntimeException() : this.getException();
    }

    private void addLocationsFromDiagnostics(List<ProblemLocation> locations, ProblemDiagnostics diagnostics) {
        PluginIdLocation pluginIdLocation;
        FileLocation fileLocation;
        Location loc = diagnostics.getLocation();
        FileLocation fileLocation2 = fileLocation = loc == null ? null : DefaultProblemBuilder.getFileLocation(loc);
        if (fileLocation != null) {
            locations.remove(fileLocation);
        }
        if (this.collectStackLocation || fileLocation != null) {
            locations.add(new DefaultStackTraceLocation(fileLocation, diagnostics.getStack()));
        }
        if ((pluginIdLocation = DefaultProblemBuilder.getDefaultPluginIdLocation(diagnostics)) != null) {
            locations.add(pluginIdLocation);
        }
    }

    @Nullable
    private static PluginIdLocation getDefaultPluginIdLocation(ProblemDiagnostics problemDiagnostics) {
        UserCodeSource source = problemDiagnostics.getSource();
        if (source == null) {
            return null;
        }
        String pluginId = source.getPluginId();
        if (pluginId == null) {
            return null;
        }
        return new DefaultPluginIdLocation(pluginId);
    }

    private static FileLocation getFileLocation(Location loc) {
        String path = loc.getFilePath();
        int line = loc.getLineNumber();
        return DefaultLineInFileLocation.from(path, line);
    }

    private InternalProblem invalidProblem(String id, String displayName, @Nullable String contextualLabel) {
        this.id(id, displayName, ProblemGroup.create("problems-api", "Problems API")).stackLocation();
        DefaultProblemDefinition problemDefinition = new DefaultProblemDefinition(this.getId(), Severity.WARNING, null);
        ArrayList<ProblemLocation> problemLocations = new ArrayList<ProblemLocation>();
        ProblemDiagnostics diagnostics = this.determineDiagnostics();
        if (diagnostics != null) {
            this.addLocationsFromDiagnostics(problemLocations, diagnostics);
        }
        return new DefaultProblem(problemDefinition, contextualLabel, (List<String>)ImmutableList.of(), problemLocations, (List<ProblemLocation>)ImmutableList.of(), null, null, null);
    }

    protected Severity getSeverity() {
        if (this.severity == null) {
            return Severity.WARNING;
        }
        return this.severity;
    }

    @Override
    public InternalProblemBuilder contextualLabel(String contextualLabel) {
        this.contextualLabel = contextualLabel;
        return this;
    }

    @Override
    public InternalProblemBuilder severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public ProblemsInfrastructure getInfrastructure() {
        return this.problemsInfrastructure;
    }

    @Override
    public InternalProblemBuilder taskLocation(String buildTreePath) {
        this.contextLocations.add(new DefaultTaskLocation(buildTreePath));
        return this;
    }

    @Override
    public InternalProblemBuilder fileLocation(String path) {
        this.addFileLocation(DefaultFileLocation.from(path));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line) {
        return this.addFileLocation(DefaultLineInFileLocation.from(path, line));
    }

    @Nonnull
    private DefaultProblemBuilder addFileLocation(FileLocation from) {
        return this.addFileLocationTo(this.originLocations, from);
    }

    @Nonnull
    private DefaultProblemBuilder addFileLocationTo(List<ProblemLocation> problemLocations, FileLocation from) {
        if (problemLocations.contains(from)) {
            return this;
        }
        problemLocations.add(from);
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line, int column) {
        this.addFileLocation(DefaultLineInFileLocation.from(path, line, column));
        return this;
    }

    @Override
    public InternalProblemBuilder offsetInFileLocation(String path, int offset, int length) {
        this.addFileLocation(DefaultOffsetInFileLocation.from(path, offset, length));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line, int column, int length) {
        this.addFileLocation(DefaultLineInFileLocation.from(path, line, column, length));
        return this;
    }

    @Override
    public InternalProblemBuilder stackLocation() {
        this.collectStackLocation = true;
        return this;
    }

    @Override
    public InternalProblemSpec diagnostics(ProblemDiagnostics diagnostics) {
        this.diagnostics = diagnostics;
        return this;
    }

    @Override
    public InternalProblemBuilder details(String details) {
        this.details = details;
        return this;
    }

    @Override
    public InternalProblemBuilder documentedAt(@Nullable DocLink doc) {
        this.docLink = doc;
        return this;
    }

    @Override
    public InternalProblemBuilder id(ProblemId problemId) {
        this.id = problemId instanceof DefaultProblemId ? problemId : DefaultProblemBuilder.cloneId(problemId);
        return this;
    }

    @Override
    public InternalProblemBuilder id(String name, String displayName, ProblemGroup parent) {
        this.id = ProblemId.create(name, displayName, DefaultProblemBuilder.cloneGroup(parent));
        return this;
    }

    private static ProblemId cloneId(ProblemId original) {
        return ProblemId.create(original.getName(), original.getDisplayName(), DefaultProblemBuilder.cloneGroup(original.getGroup()));
    }

    private static ProblemGroup cloneGroup(ProblemGroup original) {
        return ProblemGroup.create(original.getName(), original.getDisplayName(), original.getParent() == null ? null : DefaultProblemBuilder.cloneGroup(original.getParent()));
    }

    @Override
    public InternalProblemBuilder documentedAt(@Nullable String url) {
        this.docLink = url == null ? null : new DefaultDocLink(url);
        return this;
    }

    @Override
    public InternalProblemBuilder solution(@Nullable String solution) {
        if (this.solutions == null) {
            this.solutions = new ArrayList<String>();
        }
        this.solutions.add(solution);
        return this;
    }

    @Override
    public <U extends AdditionalDataSpec> InternalProblemBuilder additionalDataInternal(Class<? extends U> specType, Action<? super U> config) {
        if (this.problemsInfrastructure.getAdditionalDataBuilderFactory().hasProviderForSpec(specType)) {
            AdditionalDataBuilder<AdditionalData> additionalDataBuilder = this.problemsInfrastructure.getAdditionalDataBuilderFactory().createAdditionalDataBuilder(specType, this.additionalData);
            config.execute((Object)((AdditionalDataSpec)((Object)additionalDataBuilder)));
            this.additionalData = additionalDataBuilder.build();
        } else {
            this.additionalData = new UnsupportedAdditionalDataSpec(specType);
        }
        return this;
    }

    @Override
    public <T extends AdditionalData> InternalProblemBuilder additionalData(Class<T> type, Action<? super T> config) {
        AdditionalData additionalDataInstance = this.createAdditionalData(type, config);
        Isolatable isolated = this.problemsInfrastructure.getIsolatableFactory().isolate((Object)additionalDataInstance);
        SerializedPayload serializedBaseClass = this.problemsInfrastructure.getPayloadSerializer().serialize(type);
        byte[] serialized = this.problemsInfrastructure.getIsolatableSerializer().serialize(isolated);
        this.additionalData = new DefaultTypedAdditionalData(serializedBaseClass, serialized);
        return this;
    }

    @Nonnull
    private <T extends AdditionalData> AdditionalData createAdditionalData(Class<T> type, Action<? super T> config) {
        AdditionalData additionalDataInstance = (AdditionalData)this.problemsInfrastructure.getInstantiator().newInstance(type, new Object[0]);
        config.execute((Object)additionalDataInstance);
        return additionalDataInstance;
    }

    @Override
    public InternalProblemBuilder withException(Throwable t) {
        this.exception = t;
        return this;
    }

    @Nullable
    Throwable getException() {
        return this.exception;
    }

    public ProblemId getId() {
        return this.id;
    }

    private static class UnsupportedAdditionalDataSpec
    implements AdditionalData {
        private final Class<?> type;

        UnsupportedAdditionalDataSpec(Class<?> type) {
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

