<?php

namespace Fisharebest\Localization\Language;

use Fisharebest\Localization\PluralRule\PluralRule9;
use Fisharebest\Localization\Territory\TerritoryPl;

/**
 * Class LanguagePl - Representation of the Polish language.
 *
 * @author    Greg Roach <greg@subaqua.co.uk>
 * @copyright (c) 2022 Greg Roach
 * @license   GPL-3.0-or-later
 */
class LanguagePl extends AbstractLanguage implements LanguageInterface
{
    public function code()
    {
        return 'pl';
    }

    public function defaultTerritory()
    {
        return new TerritoryPl();
    }

    public function pluralRule()
    {
        return new PluralRule9();
    }
}
