<?php

/**
 * webtrees: online genealogy
 * Copyright (C) 2025 webtrees development team
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

namespace Fisharebest\Webtrees\Elements;

/**
 * SOURCE_DESCRIPTIVE_TITLE := {Size=1:248}
 * The title of the work, record, or item and, when appropriate, the title of the larger work or
 * series of which it is a part.
 * For a published work, a book for example, might have a title plus the title of the series of
 * which the book is a part. A magazine article would have a title plus the title of the magazine
 * that published the article.
 * For An unpublished work, such as:
 * ! A letter might include the date, the sender, and the receiver.
 * ! A transaction between a buyer and seller might have their names and the transaction date.
 * ! A family Bible containing genealogical information might have past and present owners and a
 *   physical description of the book.
 * ! A personal interview would cite the informant and interviewer.
 */
class SourceDescriptiveTitle extends AbstractElement
{
}
