# This Python file uses the following encoding: utf-8
# @author runhey
# github https://github.com/runhey


from tasks.Restart.config_scheduler import Scheduler
from tasks.Restart.login import LoginHandler
from tasks.Restart.assets import RestartAssets
from tasks.base_task import BaseTask

from module.logger import logger
from module.exception import TaskEnd, RequestHumanTakeover




class ScriptTask(LoginHandler):

    def run(self) -> None:
        """
        主要就是登录的模块
        :return:
        """
        self.app_restart()
        raise TaskEnd('ScriptTask end')


    def app_stop(self):
        logger.hr('App stop')
        self.device.app_stop()

    def app_start(self):
        logger.hr('App start')
        self.device.app_start()
        self.app_handle_login()
        # self.ensure_no_unfinished_campaign()

    def app_restart(self):
        logger.hr('App restart')
        self.device.app_stop()
        self.device.app_start()
        self.app_handle_login()

        # self.config.task_delay(server_update=True)
        self.set_next_run(task='Restart', success=True, finish=True, server=True)



if __name__ == '__main__':
    from module.config.config import Config
    from module.device.device import Device

    config = Config('oas2')
    device = Device(config)
    task = ScriptTask(config, device)
    task.app_start()









