诗词搜索结果
-----

根据该[关于诗词的知名度](https://github.com/chinese-poetry/chinese-poetry/issues/115)整理的数据，以“作者＋作品名”做为搜索关键字，通过搜索引擎搜索，并把搜索结果数量做为排行的一个维度制作而成，目前收集了“百度、必应、360搜索和谷歌”等`4`个引擎的数据，其中必应又分为中国版搜索结果和国际版搜索结果

一般来讲，搜索结果越多，表示该诗词越知名。

## 说明

该目录下收集了`ci`和`json`两个文件夹下的诗词搜索数据，且该文件夹下的文件与`ci`和`json`中的文件一一对应，比如`./ci/ci.song.rang.8000.json`对应`../ci/ci.song.8000.json`。

不但文件一一对应，文件中的内容也是一一对应的，即`./ci/ci.song.rang.8000.json`中数组中的第`n`条和`../ci/ci.song.8000.json`数组中的第`n`条对应

#### 为什么没有把该结果和诗词数据放在一起？
为了保持诗词数据的纯洁，并非所有数据都适合塞进去。对于这种非所有人需要的数据，通过一一对应关系，可以很方便的给原诗词扩展数据，同时也保证了原诗词的纯洁度。所以当需要对诗词根据知名度排序的需求时，可以把该数据附加到原有诗词数据上即可。


## 数据形式

每个 JSON 文件1000条记录. 为了举例， 删除了余下999条.

```js
[
  {
    "author": "石孝友",
    "rhythmic": "玉楼春",
    "baidu": 77500, //百度搜索结果条数
    "so360": 1060,//360搜索结果条数
    "google": 991000,//谷歌搜索结果条数
    "bing": 20//必应搜索结果条数
  }
]
```

搜索引擎的结果数据仅供参考，不同时间搜出来的数据会有一些出入
