# 词云插件 (Word Clouds)

一个功能丰富的词云生成插件，用于真寻Bot，可以生成群聊或个人的聊天词云，支持多种自定义选项和定时发送功能。通过分析聊天记录，生成直观美观的词云图片，展示群聊或个人的发言特点。

## 功能特点

- **多种词云类型**：支持今日、昨日、本周、本月、上月、本季、年度和历史自定义时间段的词云生成
- **个人/群组词云**：可以生成个人或整个群组的聊天词云，方便对比分析
- **定时发送**：支持设置定时自动发送群聊词云，无需手动触发
- **精美外观**：
  - **自定义外观**：支持多种颜色映射和背景选项
  - **亮度优化**：自动调整文字亮度，确保在不同背景下清晰可见
  - **高分辨率**：支持生成高分辨率词云图片
- **智能分词**：
  - **停用词过滤**：自动过滤无意义词汇，提高词云质量
  - **自定义词典**：支持添加自定义词典，改善分词效果

## 安装方法

1. 将本插件文件夹放置在真寻Bot的`plugins`目录下
2. 安装所需依赖：

   ```bash
   pip install -r plugins/word_clouds/requirements.txt
   ```

3. 在Bot配置中启用插件
4. 首次使用时，插件会自动下载所需的资源文件

## 使用命令

### 获取词云

#### 基础命令

- `今日词云` - 获取今日群聊词云
- `昨日词云` - 获取昨日群聊词云
- `本周词云` - 获取本周群聊词云
- `本月词云` - 获取本月群聊词云
- `上月词云` - 获取上月群聊词云
- `本季词云` - 获取本季度群聊词云
- `年度词云` - 获取年度群聊词云

#### 个人词云

- `我的今日词云` - 获取自己今日的发言词云
- `我的昨日词云` - 获取自己昨日的发言词云
- `我的本周词云` - 获取自己本周的发言词云
- `我的本月词云` - 获取自己本月的发言词云
- `我的上月词云` - 获取自己上月的发言词云
- `我的本季词云` - 获取自己本季度的发言词云
- `我的年度词云` - 获取自己年度的发言词云

#### 自定义时间范围

- `历史词云 [日期]` - 获取某日词云 (例: 历史词云 2023-01-15)
- `历史词云 [开始日期]~[结束日期]` - 获取时间段词云 (例: 历史词云 2023-01-01~2023-01-31)
- `历史词云 [开始时间]~[结束时间]` - 精确时间段 (例: 历史词云 2023-01-15T10:00:00~2023-01-15T18:30:00)

#### 超级用户命令

- `今日词云 -g <群号>` - 获取指定群的词云 (仅超级用户)
- `我的今日词云 -g <群号>` - 获取自己在指定群的词云 (仅超级用户)
- `历史词云 2023-01-01~2023-01-31 -g <群号>` - 获取指定群的历史词云 (仅超级用户)

### 定时发送功能

#### 基础命令 (需要管理员权限)

- `定时词云 开启 <时间>` - 设置当前群定时发送 (例: 定时词云 开启 22:00)
- `定时词云 关闭` - 取消当前群定时发送
- `定时词云 状态` - 查看当前群定时状态

#### 超级用户命令

- `定时词云 开启 <时间> -g <群号>` - 设置指定群定时发送 (仅超级用户)
- `定时词云 关闭 -g <群号>` - 取消指定群定时发送 (仅超级用户)
- `定时词云 状态 -g <群号>` - 查看指定群定时状态 (仅超级用户)
- `定时词云 开启 <时间> -all` - 设置所有群定时发送 (仅超级用户)
- `定时词云 关闭 -all` - 取消所有群定时发送 (仅超级用户)
- `定时词云 状态 -all` - 查看所有群定时状态 (仅超级用户)

## 配置选项

插件提供多种配置选项，可以在真寻Bot的配置界面中设置：

### 基础配置

| 配置项 | 默认值 | 说明 |
|-------|-------|------|
| WORD_CLOUDS_TEMPLATE | 1 | 词云模板类型 (1: 使用蒙版图片生成 / 其他: 纯色背景) |
| WORD_CLOUDS_MAX_WORDS | 300 | 词云中显示的最大词数 |
| WORD_CLOUDS_WIDTH | 1920 | 词云图片宽度 |
| WORD_CLOUDS_HEIGHT | 1080 | 词云图片高度 |
| WORD_CLOUDS_BACKGROUND_COLOR | None | 背景颜色 ('white'或'black'，None表示自动选择) |

### 字体与布局

| 配置项 | 默认值 | 说明 |
|-------|-------|------|
| WORD_CLOUDS_MIN_FONT_SIZE | 8 | 最小字体大小 |
| WORD_CLOUDS_MAX_FONT_SIZE | 100 | 最大字体大小 |
| WORD_CLOUDS_RELATIVE_SCALING | 0.3 | 相对缩放值，降低该值使词云更均匀 |
| WORD_CLOUDS_PREFER_HORIZONTAL | 0.7 | 水平词的比例，降低该值会增加垂直词的比例 |
| WORD_CLOUDS_COLLOCATIONS | True | 是否检测词组 |

### 亮度优化

| 配置项 | 默认值 | 说明 |
|-------|-------|------|
| WORD_CLOUDS_WHITE_BG_MAX_BRIGHTNESS | 0.7 | 白底文字最高亮度阈值，超过此值的字体颜色会被调暗 |
| WORD_CLOUDS_BLACK_BG_MIN_BRIGHTNESS | 0.3 | 黑底文字最低亮度阈值，低于此值的字体颜色会被调亮 |

### 颜色映射 (Colormap)

| 配置项 | 默认值 | 说明 |
|-------|-------|------|
| WORD_CLOUDS_COLORMAP_WHITE_BG | ["viridis", "plasma", "inferno", "magma", "Blues", "Greens", "Reds", "Purples", "RdBu", "coolwarm", "PiYG"] | 白色背景时使用的颜色映射列表，会随机选择其中之一 |
| WORD_CLOUDS_COLORMAP_BLACK_BG | ["plasma", "hot", "YlOrRd", "YlOrBr", "Oranges", "OrRd", "rainbow", "jet", "turbo", "coolwarm", "RdBu", "Spectral"] | 黑色背景时使用的颜色映射列表，会随机选择其中之一 |

## 颜色映射详解

颜色映射（Colormap）是词云中的重要视觉元素，决定了词云中文字的颜色分布。插件支持多种颜色映射，可以根据不同的背景和个人喜好进行选择。

### 颜色映射分类

#### 感知均匀顺序色图

这类色图在亮度和色调上变化均匀，适合表示连续数据，在任何背景下都有良好的可读性。

- `viridis` - 蓝紫黄渐变，matplotlib的默认色图
- `plasma` - 紫红黄渐变，鲜艳且高对比度
- `inferno` - 黑紫黄白渐变，热力图风格
- `magma` - 黑紫粉白渐变，类似熔岩
- `cividis` - 蓝黄渐变，色盲友好设计

#### 顺序色图

单色或双色渐变，适合表示从低到高的数值变化。

- `Blues`, `Greens`, `Reds`, `Purples`, `Oranges` - 单色由浅至深
- `YlOrBr`, `YlOrRd`, `OrRd` - 黄橙红系渐变
- `PuRd`, `RdPu`, `BuPu` - 紫红系渐变
- `GnBu`, `PuBu`, `YlGnBu` - 蓝绿系渐变
- `PuBuGn`, `BuGn`, `YlGn` - 绿系渐变

#### 顺序色图2

包含更多特殊效果的顺序色图。

- `binary`, `gist_yarg`, `gist_gray`, `gray` - 黑白灰系
- `bone` - 蓝白黑渐变，类似X光片
- `pink` - 黑粉白渐变
- `spring`, `summer`, `autumn`, `winter` - 四季色系
- `cool`, `hot` - 冷暖色调
- `copper` - 铜色渐变

#### 发散色图

从中间向两端发散的色图，适合表示有正负之分的数据。

- `PiYG`, `PRGn`, `BrBG` - 粉绿、紫绿、棕绿对比
- `PuOr`, `RdGy`, `RdBu` - 紫橙、红灰、红蓝对比
- `RdYlBu`, `RdYlGn` - 红黄蓝、红黄绿渐变
- `Spectral` - 光谱色彩
- `coolwarm` - 冷暖色对比
- `seismic` - 地震图配色

#### 循环色图

首尾相接的循环色彩，适合表示角度、时间等循环数据。

- `twilight`, `twilight_shifted` - 暮光系列
- `hsv` - HSV色彩空间

#### 定性色图

不同色相的离散颜色，适合表示分类数据。

- `Pastel1`, `Pastel2` - 柔和的粉彩色
- `Paired` - 成对的对比色
- `Accent` - 强调色
- `Dark2` - 深色系
- `Set1`, `Set2`, `Set3` - 不同色相集合
- `tab10`, `tab20`, `tab20b`, `tab20c` - Tableau调色板

### 背景适配推荐

#### 白色背景推荐

白色背景适合使用较深的颜色映射，使文字清晰可见：

- `viridis`, `plasma`, `inferno`, `magma`, `cividis`
- `Blues`, `Greens`, `Reds`, `Purples`
- `RdBu`, `coolwarm`, `PiYG`, `PRGn`
- `ocean`, `terrain`, `gist_earth`

#### 黑色背景推荐

黑色背景适合使用较亮或高对比度的颜色映射：

- `plasma`, `hot`, `YlOrRd`, `YlOrBr`
- `Oranges`, `OrRd`, `rainbow`, `jet`, `turbo`
- `coolwarm`, `RdBu`, `Spectral`
- `autumn`, `summer`, `spring`, `winter`

### 自定义颜色映射

您可以在配置中自定义颜色映射列表：

```python
# 白色背景颜色映射
WORD_CLOUDS_COLORMAP_WHITE_BG = ["viridis", "Blues", "Greens", "coolwarm"]

# 黑色背景颜色映射
WORD_CLOUDS_COLORMAP_BLACK_BG = ["plasma", "hot", "rainbow", "jet"]
```

## 自定义分词

### 停用词设置

插件支持自定义停用词，用于过滤不需要显示在词云中的词语：

1. 在 `data/word_cloud/wordcloud_stopwords.txt` 中添加停用词，每行一个
2. 在 `plugins/word_clouds/assets/stopwords.txt` 中添加额外的停用词

> **提示**：停用词通常包括虚词、助词、标点符号等对词云内容无实质意义的词语。

### 自定义词典

可以在 `data/word_cloud/wordcloud_userdict.txt` 中添加自定义词典，每行一个词语，用于改善分词效果。

> **提示**：自定义词典可以添加专有名词、网络用语等常规分词器可能无法正确识别的词语。

## 资源文件

插件会自动下载并管理所需的资源文件：

- **词云背景图片**：保存在 `resources/image/wordcloud/` 目录下
  - 可以添加自己的图片作为词云背景
  - 支持多张图片，会随机选择一张作为背景
- **字体文件**：保存在 `resources/font/` 目录下
  - 默认使用 `STKAITI.TTF` (楷体)

## 高级功能

### 图像优化

- 支持高分辨率词云生成（默认分辨率倍数为1.5倍）
- 自动调整文字亮度，确保在不同背景下清晰可见
- 使用高质量图像保存参数，确保词云图片清晰美观

## 依赖项

主要依赖项：

- wordcloud>=1.8.0 - 词云生成核心库
- matplotlib>=3.5.0 - 提供颜色映射支持
- numpy>=1.20.0 - 数组处理
- Pillow>=9.0.0 - 图像处理
- spacy-pkuseg>=0.0.31 - 中文分词
- emoji>=2.0.0 - 表情符号处理

详见 `requirements.txt` 文件。

## 关于

- **作者**：yajiwa
- **版本**：1.3.5
- **插件类型**：功能型插件
- **许可证**：本插件遵循与真寻Bot相同的许可证
