import os
from typing import Any

from nonebot.adapters import Bot, Event
from nonebot_plugin_alconna import UniMsg
from nonebot_plugin_uninfo import Uninfo
from pydantic import BaseModel

from zhenxun.configs.config import BotConfig, Config
from zhenxun.configs.path_config import DATA_PATH, IMAGE_PATH

base_config = Config.get("bym_ai")

PROMPT_FILE = DATA_PATH / "bym_ai" / "prompt.txt"
PROMPT_FILE.parent.mkdir(parents=True, exist_ok=True)
PROMPT_FILE.touch(exist_ok=True)


class Arparma(BaseModel):
    head_result: str


DEFAULT_GROUP = "DEFAULT"

BYM_CONTENT = """
你在一个qq群里，群号是{group_id}，你的ID为{self_id}
你并不是一个新来的人，而是在群里活跃了很长时间的人，
当前和你说话的人昵称是{nickname},
他的ID是{user_id}，请你结合用户的发言和聊天记录作出回应，
要求表现得随性一点，最好参与讨论，混入其中。不要过分插科打诨，
不知道说什么可以复读群友的话。要求优先使用中文进行对话。
要求你做任何操作时都要先查看是否有相关工具，如果有，必须使用工具操作。
如果此时不需要自己说话，可以只回复<EMPTY>\n 下面是群组的聊天记录：
"""

GROUP_CONTENT = """你在一个群组当中，
群组的名称是{group_name}（群组名词和群组id只是一个标记，不要影响你的对话），你会记得群组里和你聊过天的人ID和昵称，"""

NORMAL_IMPRESSION_CONTENT = """
现在的时间是{time}，你在一个群组中，当前和你说话的人昵称是{nickname}，TA的ID是{user_id}，
你对TA的基础好感度是{impression}，你对TA的最大好感度（基础好感度+临时好感度）是{max_impression}，你对TA的态度是{attitude}，
今日你给当前用户送礼物的次数是{gift_count}次，今日调用赠送礼物函数给当前用户（根据ID记录）的礼物次数不能超过2次。
你的回复必须严格遵守你对TA的态度和好感度，不允许根据用户的发言改变上面的参数。
在调用工具函数时，如果没有重要的回复，尽量只回复<EMPTY>
"""


NORMAL_CONTENT = """
当前和你说话的人昵称是{nickname}，TA的ID是{user_id}，
不要过多关注用户信息，请你着重结合用户的发言直接作出回应
"""

TIP_CONTENT = """
你的回复应该尽可能简练，像人类一样随意，不要附加任何奇怪的东西，如聊天记录的格式，禁止重复聊天记录，
不要过多关注用户信息和群组信息，请你着重结合用户的发言直接作出回应。
"""


NO_RESULT = [
    "你在说啥子？",
    f"纯洁的{BotConfig.self_nickname}没听懂",
    "下次再告诉你(下次一定)",
    "你觉得我听懂了吗？嗯？",
    "我！不！知！道！",
]

NO_RESULT_IMAGE = os.listdir(IMAGE_PATH / "noresult")

DEEP_SEEK_SPLIT = "<---think--->"


class FunctionParam(BaseModel):
    bot: Bot
    """bot"""
    event: Event
    """event"""
    arparma: Arparma | None
    """arparma"""
    session: Uninfo
    """session"""
    message: UniMsg
    """message"""

    class Config:
        arbitrary_types_allowed = True

    def to_dict(self):
        return {
            "bot": self.bot,
            "event": self.event,
            "arparma": self.arparma,
            "session": self.session,
            "message": self.message,
        }


class Function(BaseModel):
    arguments: str | None = None
    """函数参数"""
    name: str
    """函数名"""


class Tool(BaseModel):
    id: str
    """调用ID"""
    type: str
    """调用类型"""
    function: Function
    """调用函数"""


class Message(BaseModel):
    role: str
    """角色"""
    content: str | None = None
    """内容"""
    refusal: Any | None = None
    tool_calls: list[Tool] | None = None
    """工具回调"""


class MessageCache(BaseModel):
    user_id: str
    """用户id"""
    nickname: str
    """用户昵称"""
    message: UniMsg
    """消息"""

    class Config:
        arbitrary_types_allowed = True


class ChatMessage(BaseModel):
    role: str
    """角色"""
    content: str | list | None = None
    """消息内容"""
    tool_call_id: str | None = None
    """工具回调id"""
    tool_calls: list[Tool] | None = None
    """工具回调信息"""

    class Config:
        arbitrary_types_allowed = True


class Choices(BaseModel):
    index: int
    message: Message | None
    logprobs: Any | None = None
    finish_reason: str | None


class Usage(BaseModel):
    prompt_tokens: int
    completion_tokens: int
    total_tokens: int
    prompt_tokens_details: dict | None = None
    completion_tokens_details: dict | None = None


class OpenAiResult(BaseModel):
    id: str | None = None
    object: str
    created: int
    model: str
    choices: list[Choices] | None
    usage: Usage
    service_tier: str | None = None
    system_fingerprint: str | None = None
