/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authc.LogoutAware;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.Nameable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingRealm
implements Realm,
Nameable,
CacheManagerAware,
LogoutAware {
    private static final Logger log = LoggerFactory.getLogger(CachingRealm.class);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private String name = this.getClass().getName() + "_" + INSTANCE_COUNT.getAndIncrement();
    private boolean cachingEnabled = true;
    private CacheManager cacheManager;

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.afterCacheManagerSet();
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected void afterCacheManagerSet() {
    }

    @Override
    public void onLogout(PrincipalCollection principals) {
        this.clearCache(principals);
    }

    protected void clearCache(PrincipalCollection principals) {
        if (!CollectionUtils.isEmpty(principals)) {
            this.doClearCache(principals);
            log.trace("Cleared cache entries for account with principals [{}]", principals);
        }
    }

    protected void doClearCache(PrincipalCollection principals) {
    }

    protected Object getAvailablePrincipal(PrincipalCollection principals) {
        Object primary = null;
        if (!CollectionUtils.isEmpty(principals)) {
            Collection thisPrincipals = principals.fromRealm(this.getName());
            primary = !CollectionUtils.isEmpty(thisPrincipals) ? thisPrincipals.iterator().next() : principals.getPrimaryPrincipal();
        }
        return primary;
    }
}

