/*
 * Decompiled with CFR 0.152.
 */
package cn.safe6.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class Reflections {
    public static Object getFieldValue(Object object, String field) throws Exception {
        Field f0 = Reflections.getField(object, field);
        return f0.get(object);
    }

    public static Constructor<?> getFirstCtor(String name) throws Exception {
        Constructor<?> ctor = Class.forName(name).getDeclaredConstructors()[0];
        Reflections.setAccessible(ctor);
        return ctor;
    }

    public static void setAccessible(AccessibleObject member) {
        String versionStr = System.getProperty("java.version");
        int javaVersion = Integer.parseInt(versionStr.split("\\.")[0]);
        if (javaVersion >= 12) {
            member.setAccessible(true);
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object fieldValue) throws Exception {
        Field field = Reflections.getField(object, fieldName);
        field.set(object, fieldValue);
    }

    public static Field getField(Object object, String fieldName) throws Exception {
        Field field = null;
        for (Class<?> clas = object.getClass(); clas != Object.class; clas = clas.getSuperclass()) {
            try {
                field = clas.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (field != null) {
            field.setAccessible(true);
            return field;
        }
        return null;
    }
}

