/*
 * Decompiled with CFR 0.152.
 */
package cn.safe6.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javafx.application.Platform;
import javafx.scene.control.TextArea;

public class LogUtil {
    private TextArea log;
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public LogUtil(TextArea log) {
        this.log = log;
    }

    public void printAbortedLog(String text, boolean isEnd) {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Platform.runLater(() -> {
            this.log.appendText("[-] " + this.getNowTime() + "  " + text + "\r\n");
            if (isEnd) {
                this.log.selectPositionCaret(this.log.getText().length());
            }
        });
    }

    public void printSucceedLog(String text) {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Platform.runLater(() -> {
            this.log.appendText("[+] " + this.getNowTime() + "  " + text + "\r\n");
            this.log.appendText("---------------------------\r\n");
            this.log.selectPositionCaret(this.log.getText().length());
        });
    }

    public void printData(String text) {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Platform.runLater(() -> {
            this.log.setText("");
            this.log.appendText("\r\n---------------\r\n" + text + "\r\n\r\n");
            this.log.selectPositionCaret(this.log.getText().length());
        });
    }

    public void printInfoLog(String text, boolean isEnd) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Platform.runLater(() -> {
            this.log.appendText("[*] " + this.getNowTime() + "  " + text + "\r\n");
            if (isEnd) {
                this.log.selectPositionCaret(this.log.getText().length());
            }
        });
    }

    public void printWarningLog(String text, boolean isEnd) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Platform.runLater(() -> {
            this.log.appendText("[!] " + this.getNowTime() + "  " + text + "\r\n");
            if (isEnd) {
                this.log.selectPositionCaret(this.log.getText().length());
            }
        });
    }

    public TextArea getLog() {
        return this.log;
    }

    public String getNowTime() {
        return LocalDateTime.now().format(this.formatter);
    }
}

