/*
 * Decompiled with CFR 0.152.
 */
package cn.safe6.util;

import cn.safe6.controller.Controller;
import cn.safe6.core.http.Request;
import cn.safe6.core.http.Response;
import cn.safe6.util.MyCERT;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HttpTool {
    private static int Timeout = 600;
    private static String DefalutEncoding = "UTF-8";
    public static HostnameVerifier allHostsValid = (hostname, session) -> true;

    public static String httpRequest(String requestUrl, int timeOut, String requestMethod, String contentType, String postString, String encoding) throws Exception {
        if ("".equals(encoding) || encoding == null) {
            encoding = DefalutEncoding;
        }
        HttpURLConnection httpUrlConn = null;
        HttpURLConnection hsc = null;
        HttpURLConnection hc = null;
        InputStream inputStream = null;
        try {
            String result;
            URL url = new URL(requestUrl);
            if (requestUrl.startsWith("https")) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                TrustManager[] tm = new TrustManager[]{new MyCERT()};
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                Proxy proxy = (Proxy)Controller.settingInfo.get("proxy");
                hsc = proxy != null ? (HttpsURLConnection)url.openConnection(proxy) : (HttpsURLConnection)url.openConnection();
                ((HttpsURLConnection)hsc).setSSLSocketFactory(ssf);
                ((HttpsURLConnection)hsc).setHostnameVerifier(allHostsValid);
                httpUrlConn = hsc;
            } else {
                Proxy proxy = (Proxy)Controller.settingInfo.get("proxy");
                hc = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
                hc.setRequestMethod(requestMethod);
                hc.setInstanceFollowRedirects(false);
                System.out.println(hc.getRequestProperties());
                httpUrlConn = hc;
            }
            httpUrlConn.setConnectTimeout(timeOut);
            httpUrlConn.setReadTimeout(timeOut);
            if (contentType != null && !"".equals(contentType)) {
                httpUrlConn.setRequestProperty("Content-Type", contentType);
            }
            httpUrlConn.setRequestProperty("User-Agent", "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)");
            httpUrlConn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9");
            httpUrlConn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            httpUrlConn.setRequestProperty("Accept-Language", "zh-CN,zh;q=0.9");
            httpUrlConn.setRequestProperty("Connection", "close");
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.connect();
            if (null != postString && !"".equals(postString)) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(postString.getBytes(encoding));
                outputStream.flush();
                outputStream.close();
            }
            inputStream = httpUrlConn.getInputStream();
            String string = result = HttpTool.readString(inputStream, encoding);
            return string;
        }
        catch (IOException ie) {
            System.out.println(ie);
            if (hsc != null) {
                String string = HttpTool.readString(hsc.getErrorStream(), encoding);
                return string;
            }
            if (hc != null) {
                String string = HttpTool.readString(hc.getErrorStream(), encoding);
                return string;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            System.out.println(e);
            throw e;
        }
        finally {
            if (hsc != null) {
                hsc.disconnect();
            }
            if (hc != null) {
                hc.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream inputStream, String encoding) throws IOException {
        BufferedInputStream bis = null;
        OutputStream baos = null;
        try {
            bis = new BufferedInputStream(inputStream);
            baos = new ByteArrayOutputStream();
            int len = 0;
            byte[] arr = new byte[1];
            while ((len = bis.read(arr)) != -1) {
                ((ByteArrayOutputStream)baos).write(arr, 0, len);
            }
        }
        catch (IOException iOException) {}
        finally {
            if (baos != null) {
                baos.flush();
                ((ByteArrayOutputStream)baos).close();
            }
            if (bis != null) {
                bis.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            return ((ByteArrayOutputStream)baos).toString(encoding);
        }
    }

    public static String httpRequestAddHeader(String requestUrl, int timeOut, String requestMethod, String contentType, String postString, String encoding, Map<String, Object> headers) throws Exception {
        if ("".equals(encoding) || encoding == null) {
            encoding = DefalutEncoding;
        }
        HttpURLConnection httpUrlConn = null;
        HttpURLConnection hsc = null;
        HttpURLConnection hc = null;
        InputStream inputStream = null;
        Object res = null;
        try {
            URL url = new URL(requestUrl);
            if (requestUrl.startsWith("https")) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                TrustManager[] tm = new TrustManager[]{new MyCERT()};
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                Proxy proxy = (Proxy)Controller.settingInfo.get("proxy");
                hsc = proxy != null ? (HttpsURLConnection)url.openConnection(proxy) : (HttpsURLConnection)url.openConnection();
                ((HttpsURLConnection)hsc).setSSLSocketFactory(ssf);
                ((HttpsURLConnection)hsc).setHostnameVerifier(allHostsValid);
                httpUrlConn = hsc;
            } else {
                Proxy proxy = (Proxy)Controller.settingInfo.get("proxy");
                hc = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
                hc.setRequestMethod(requestMethod);
                hc.setInstanceFollowRedirects(false);
                httpUrlConn = hc;
            }
            httpUrlConn.setConnectTimeout(timeOut);
            httpUrlConn.setReadTimeout(timeOut);
            if (contentType != null && !"".equals(contentType)) {
                httpUrlConn.setRequestProperty("Content-Type", contentType);
            }
            httpUrlConn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36");
            if (headers != null) {
                for (String key : headers.keySet()) {
                    String val = headers.get(key).toString();
                    httpUrlConn.addRequestProperty(key, val);
                }
            }
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.connect();
            if (null != postString && !"".equals(postString)) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(postString.getBytes(encoding));
                outputStream.close();
            }
            inputStream = httpUrlConn.getInputStream();
            String result = HttpTool.readString(inputStream, encoding);
            if (hsc != null) {
                hsc.disconnect();
            }
            if (hc != null) {
                hc.disconnect();
            }
            return result;
        }
        catch (Exception e) {
            if (hsc != null) {
                hsc.disconnect();
            }
            if (hc != null) {
                hc.disconnect();
            }
            throw e;
        }
    }

    public static Response httpRequestAddHeader1(String requestUrl, int timeOut, String requestMethod, String postString, String encoding, Map<String, Object> headers) throws Exception {
        if ("".equals(encoding) || encoding == null) {
            encoding = DefalutEncoding;
        }
        HttpURLConnection httpUrlConn = null;
        HttpURLConnection hsc = null;
        HttpURLConnection hc = null;
        InputStream inputStream = null;
        Object res = null;
        Response response = new Response();
        try {
            URL url = new URL(requestUrl);
            if (requestUrl.startsWith("https")) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                TrustManager[] tm = new TrustManager[]{new MyCERT()};
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                Proxy proxy = (Proxy)Controller.settingInfo.get("proxy");
                hsc = proxy != null ? (HttpsURLConnection)url.openConnection(proxy) : (HttpsURLConnection)url.openConnection();
                ((HttpsURLConnection)hsc).setSSLSocketFactory(ssf);
                ((HttpsURLConnection)hsc).setHostnameVerifier(allHostsValid);
                httpUrlConn = hsc;
            } else {
                Proxy proxy = (Proxy)Controller.settingInfo.get("proxy");
                hc = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
                hc.setRequestMethod(requestMethod);
                hc.setInstanceFollowRedirects(false);
                httpUrlConn = hc;
            }
            httpUrlConn.setConnectTimeout(timeOut);
            httpUrlConn.setReadTimeout(timeOut);
            httpUrlConn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36");
            if (headers != null) {
                for (String key : headers.keySet()) {
                    String val = headers.get(key).toString();
                    httpUrlConn.addRequestProperty(key, val);
                }
            }
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.connect();
            if (null != postString && !"".equals(postString)) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(postString.getBytes(encoding));
                outputStream.close();
            }
            inputStream = httpUrlConn.getInputStream();
            response.setHeader(httpUrlConn.getHeaderFields());
            String result = HttpTool.readString(inputStream, encoding);
            response.setData(result);
            if (hsc != null) {
                hsc.disconnect();
                response.setCode(hsc.getResponseCode());
            }
            if (hc != null) {
                hc.disconnect();
                response.setCode(hc.getResponseCode());
            }
            return response;
        }
        catch (Exception e) {
            if (hsc != null) {
                hsc.disconnect();
            }
            if (hc != null) {
                hc.disconnect();
            }
            throw e;
        }
    }

    public static int codeByHttpRequest(String requestUrl, int timeOut, String requestMethod, String contentType, String postString, String encoding) throws Exception {
        if ("".equals(encoding) || encoding == null) {
            encoding = DefalutEncoding;
        }
        HttpURLConnection httpUrlConn = null;
        HttpURLConnection hsc = null;
        HttpURLConnection hc = null;
        InputStream inputStream = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            URL url = new URL(requestUrl);
            if (requestUrl.startsWith("https")) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                TrustManager[] tm = new TrustManager[]{new MyCERT()};
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                hsc = (HttpsURLConnection)url.openConnection();
                ((HttpsURLConnection)hsc).setSSLSocketFactory(ssf);
                ((HttpsURLConnection)hsc).setHostnameVerifier(allHostsValid);
                httpUrlConn = hsc;
            } else {
                hc = (HttpURLConnection)url.openConnection();
                hc.setRequestMethod(requestMethod);
                httpUrlConn = hc;
            }
            httpUrlConn.setReadTimeout(timeOut);
            if (contentType != null && !"".equals(contentType)) {
                httpUrlConn.setRequestProperty("Content-Type", contentType);
            }
            httpUrlConn.setRequestProperty("User-Agent", "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)");
            httpUrlConn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9");
            httpUrlConn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            httpUrlConn.setRequestProperty("Accept-Language", "zh-CN,zh;q=0.9");
            httpUrlConn.setRequestProperty("Connection", "close");
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.connect();
            if (null != postString && !"".equals(postString)) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(postString.getBytes(encoding));
                outputStream.close();
            }
            if (hsc != null) {
                int n = hsc.getResponseCode();
                return n;
            }
            if (hc != null) {
                int n = hc.getResponseCode();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (hsc != null) {
                hsc.disconnect();
            }
            if (hc != null) {
                hc.disconnect();
            }
        }
    }

    public static String httpReuest(String requestUrl, String method, String contentType, String postString, String encoding) throws Exception {
        return HttpTool.httpRequest(requestUrl, Timeout, method, contentType, postString, encoding);
    }

    public static String get(String url, String encoding) throws Exception {
        return HttpTool.httpRequest(url, Timeout, "GET", "application/x-www-form-urlencoded", "", encoding);
    }

    public static String get(String url) throws Exception {
        return HttpTool.httpRequest(url, Timeout, "GET", "application/x-www-form-urlencoded", "", DefalutEncoding);
    }

    public static Response get1(String url) throws Exception {
        return HttpTool.httpRequestAddHeader1(url, Timeout, "GET", null, DefalutEncoding, null);
    }

    public static Response get1(String url, Map<String, Object> headers) throws Exception {
        return HttpTool.httpRequestAddHeader1(url, Timeout, "GET", null, DefalutEncoding, headers);
    }

    public static String get(String url, String postString, String encoding, Map<String, Object> headers, String contentType) throws Exception {
        return HttpTool.httpRequestAddHeader(url, Timeout, "GET", contentType, postString, encoding, headers);
    }

    public static String get(String url, String encoding, Map<String, Object> headers) throws Exception {
        return HttpTool.httpRequestAddHeader(url, Timeout, "GET", "application/x-www-form-urlencoded", "", encoding, headers);
    }

    public static String get(String url, Map<String, Object> headers) throws Exception {
        return HttpTool.httpRequestAddHeader(url, Timeout, "GET", "application/x-www-form-urlencoded", "", DefalutEncoding, headers);
    }

    public static String post(String url, String postData, Map<String, Object> headers) throws Exception {
        return HttpTool.httpRequestAddHeader(url, Timeout, "POST", null, postData, DefalutEncoding, headers);
    }

    public static String postHttpReuest(String requestUrl, int timeOut, String contentType, String postString, String encoding) throws Exception {
        return HttpTool.httpRequest(requestUrl, timeOut, "POST", contentType, postString, encoding);
    }

    public static String postHttpReuest(String requestUrl, String postString, String encoding, Map<String, Object> headers, String contentType) throws Exception {
        return HttpTool.httpRequestAddHeader(requestUrl, Timeout, "POST", contentType, postString, encoding, headers);
    }

    public static String postHttpReuest(String requestUrl, String contentType, String postString, String encoding) throws Exception {
        return HttpTool.httpRequest(requestUrl, Timeout, "POST", contentType, postString, encoding);
    }

    public static String postHttpReuest(String requestUrl, int timeOut, String postString, String encoding) throws Exception {
        return HttpTool.httpRequest(requestUrl, timeOut, "POST", "application/x-www-form-urlencoded", postString, encoding);
    }

    public static String postHttpReuest(String requestUrl, String postString, String encoding) throws Exception {
        return HttpTool.httpRequest(requestUrl, Timeout, "POST", "application/x-www-form-urlencoded", postString, encoding);
    }

    public static String postHttpReuestByXML(String requestUrl, int timeOut, String postString, String encoding) throws Exception {
        return HttpTool.httpRequest(requestUrl, timeOut, "POST", "text/xml", postString, encoding);
    }

    public static String postHttpReuestByXML(String requestUrl, String postString, String encoding) throws Exception {
        return HttpTool.httpRequest(requestUrl, Timeout, "POST", "text/xml", postString, encoding);
    }

    public static String postHttpReuestByXMLAddHeader(String requestUrl, String postString, String encoding, Map<String, Object> headers) throws Exception {
        return HttpTool.httpRequestAddHeader(requestUrl, Timeout, "POST", "text/xml", postString, encoding, headers);
    }

    public static int codeByHttpRequest(String requestUrl, String method, String contentType, String postString, String encoding) throws Exception {
        return HttpTool.codeByHttpRequest(requestUrl, Timeout, method, contentType, postString, encoding);
    }

    public static int getCodeByHttpRequest(String requestUrl, String encoding) throws Exception {
        return HttpTool.codeByHttpRequest(requestUrl, "GET", null, "", encoding);
    }

    public static int getCodeByHttpRequest(String requestUrl, int timeout, String encoding) throws Exception {
        return HttpTool.codeByHttpRequest(requestUrl, timeout, "GET", null, "", encoding);
    }

    public static String getHttpReuest(String requestUrl, String contentType, String encoding) throws Exception {
        return HttpTool.httpRequest(requestUrl, Timeout, "GET", contentType, "", encoding);
    }

    public static int postCodeByHttpRequest(String requestUrl, String contentType, String postString, String encoding) throws Exception {
        return HttpTool.codeByHttpRequest(requestUrl, Timeout, "POST", contentType, postString, encoding);
    }

    public static int postCodeByHttpRequestWithNoContenType(String requestUrl, String postString, String encoding) throws Exception {
        return HttpTool.codeByHttpRequest(requestUrl, Timeout, "POST", null, postString, encoding);
    }

    public static int postCodeByHttpRequest(String requestUrl, String encoding) throws Exception {
        return HttpTool.codeByHttpRequest(requestUrl, Timeout, "POST", null, null, encoding);
    }

    public static int postCodeByHttpRequest(String requestUrl, String postString, String encoding) throws Exception {
        return HttpTool.codeByHttpRequest(requestUrl, Timeout, "POST", "application/x-www-form-urlencoded", postString, encoding);
    }

    public static int postCodeByHttpRequestXML(String requestUrl, String postString, String encoding) throws Exception {
        return HttpTool.codeByHttpRequest(requestUrl, Timeout, "POST", "text/xml", postString, encoding);
    }

    public static boolean downloadFile(String downURL, File file) throws Exception {
        HttpURLConnection httpURLConnection = null;
        BufferedInputStream bin = null;
        OutputStream out = null;
        try {
            URL url = new URL(downURL);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.connect();
            bin = new BufferedInputStream(httpURLConnection.getInputStream());
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            int size = 0;
            int len = 0;
            byte[] buf = new byte[1024];
            while ((size = bin.read(buf)) != -1) {
                len += size;
                out.write(buf, 0, size);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bin != null) {
                bin.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return true;
    }

    public static boolean downloadFile(String downURL, String path) throws Exception {
        return HttpTool.downloadFile(downURL, new File(path));
    }

    public static Request parseRequest(String body) {
        Request request = new Request();
        body = body.trim();
        String[] parts = (body = body.replace("cookie", "Cookie")).split("\r\n\r\n|\r\r|\n\n");
        if (parts.length < 2) {
            return null;
        }
        HashMap<String, Object> ps = new HashMap<String, Object>();
        String paramsStr = parts[1];
        if (paramsStr.contains("&")) {
            String[] params;
            for (String temp : params = paramsStr.split("&")) {
                String[] temps = temp.trim().split("=");
                ps.put(temps[0], paramsStr);
            }
            request.setParams(ps);
        }
        request.setParamsStr(paramsStr);
        String[] lines = parts[0].split("\r\n|\r|\n");
        String requestLine = lines[0].trim();
        parts = requestLine.split("\\s+");
        String requestMethod = parts[0];
        System.out.println(requestMethod);
        request.setRequestMethod(requestMethod);
        String requestURI = parts[1];
        request.setRequestUrl(requestURI);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (int i = 1; i < lines.length; ++i) {
            String[] pair = lines[i].trim().split(":", 2);
            headers.put(pair[0].trim(), pair[1].trim());
        }
        request.setHeader(headers);
        String cookie = headers.get("Cookie").toString();
        if (cookie != null) {
            String[] cookies;
            HashMap<String, String> ck = new HashMap<String, String>();
            for (String temp : cookies = cookie.trim().split(";")) {
                String[] temps = temp.trim().split("=");
                ck.put(temps[0], temps[1]);
            }
            request.setCookies(ck);
        }
        return request;
    }
}

