/*
 * Decompiled with CFR 0.152.
 */
package cn.safe6.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static PoolingHttpClientConnectionManager cm;
    private static String EMPTY_STR;
    private static String UTF_8;
    public static String CURRENT;
    public static int timeOut;
    private static SSLConnectionSocketFactory sslsf;

    private static void init() {
        if (cm == null) {
            try {
                SSLContext sslContext = HttpClientUtil.getSSLContext(true, null, null);
                NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
                sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (IOException | CertificateException e) {
                e.printStackTrace();
            }
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.INSTANCE).register("https", (PlainConnectionSocketFactory)((Object)sslsf)).build();
            cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(5000);
            cm.setDefaultMaxPerRoute(1000);
        }
    }

    private static SSLContext getSSLContext(boolean isDeceive, File creFile, String crePwd) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, FileNotFoundException, IOException {
        SSLContext sslContext = null;
        if (isDeceive) {
            sslContext = SSLContext.getInstance("SSLv3");
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
        } else if (null != creFile && creFile.length() > 0L) {
            if (null != crePwd) {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(new FileInputStream(creFile), crePwd.toCharArray());
                sslContext = SSLContexts.custom().loadTrustMaterial(keyStore, new TrustSelfSignedStrategy()).build();
            } else {
                throw new SSLHandshakeException("\u6574\u6570\u5bc6\u7801\u4e3a\u7a7a");
            }
        }
        return sslContext;
    }

    public static CloseableHttpClient getHttpClient() {
        HttpClientUtil.init();
        HttpRequestRetryHandler retryHandler = new HttpRequestRetryHandler(){

            @Override
            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 3) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return true;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt(context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(cm).setSSLSocketFactory(sslsf).setRetryHandler(retryHandler);
        return builder.build();
    }

    public static String httpGetRequest(String url) {
        HttpGet httpGet = new HttpGet(url);
        return HttpClientUtil.getResult(httpGet);
    }

    public static CloseableHttpResponse httpGetRequest3(String url, Map<String, Object> headers) {
        HttpGet httpGet = new HttpGet(url);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpGet.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        try {
            return HttpClientUtil.getHttpClient().execute(httpGet);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static CloseableHttpResponse get(String url) {
        HttpGet httpGet = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeOut * 1000).build();
        httpGet.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36");
        httpGet.setConfig(requestConfig);
        try {
            return HttpClientUtil.getHttpClient().execute(httpGet);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static CloseableHttpResponse head(String url) {
        HttpHead httpHead = new HttpHead(url);
        httpHead.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36");
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeOut * 1000).build();
        httpHead.setConfig(requestConfig);
        try {
            return HttpClientUtil.getHttpClient().execute(httpHead);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static String httpGetRequest1(String url, Map<String, Object> headers) {
        HttpGet httpGet = new HttpGet(url);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpGet.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        return HttpClientUtil.getResult(httpGet);
    }

    public static String httpHeadRequest(String url) {
        HttpHead httpHead = new HttpHead(url);
        return HttpClientUtil.getResult(httpHead);
    }

    public static String httpGetRequest(String url, Map<String, Object> headers) throws URISyntaxException {
        HttpGet httpGet = new HttpGet(url);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpGet.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        return HttpClientUtil.getResult(httpGet);
    }

    public static String httpPostRequest(String url) {
        HttpPost httpPost = new HttpPost(url);
        return HttpClientUtil.getResult(httpPost);
    }

    public static String httpPostRequest1(String url, Map<String, Object> headers) {
        HttpPost httpPost = new HttpPost(url);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpPost.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        return HttpClientUtil.getResult(httpPost);
    }

    public static String httpPostRequest(String url, Map<String, Object> params) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        ArrayList<NameValuePair> pairs = HttpClientUtil.covertParams2NVPS(params);
        httpPost.setEntity(new UrlEncodedFormEntity(pairs, UTF_8));
        return HttpClientUtil.getResult(httpPost);
    }

    public static String httpPostRequest(String url, Map<String, Object> headers, Map<String, Object> params) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpPost.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        ArrayList<NameValuePair> pairs = HttpClientUtil.covertParams2NVPS(params);
        httpPost.setEntity(new UrlEncodedFormEntity(pairs, UTF_8));
        return HttpClientUtil.getResult(httpPost);
    }

    public static CloseableHttpResponse httpPostRequest2(String url, Map<String, Object> headers, Map<String, Object> params) {
        HttpPost httpPost = new HttpPost(url);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpPost.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        try {
            ArrayList<NameValuePair> pairs = HttpClientUtil.covertParams2NVPS(params);
            httpPost.setEntity(new UrlEncodedFormEntity(pairs, UTF_8));
            return HttpClientUtil.getHttpClient().execute(httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return null;
        }
    }

    private static ArrayList<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getKey().equals("avars[1][]")) {
                pairs.add(new BasicNameValuePair("vars[1][]", String.valueOf(param.getValue())));
                continue;
            }
            pairs.add(new BasicNameValuePair(param.getKey(), String.valueOf(param.getValue())));
        }
        return pairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResult(HttpRequestBase request) {
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute(request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String string = EntityUtils.toString(entity, "utf-8");
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                assert (response != null);
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return EMPTY_STR;
    }

    public static String getResult(CloseableHttpResponse response) {
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String result = EntityUtils.toString(entity, "utf-8");
                response.close();
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return EMPTY_STR;
    }

    static {
        EMPTY_STR = "none";
        UTF_8 = "UTF-8";
        CURRENT = "";
        timeOut = 10;
    }
}

