/*
 * Decompiled with CFR 0.152.
 */
package cn.safe6.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SuidClassLoader
extends ClassLoader {
    private Map<String, byte[]> classByteMap = new HashMap<String, byte[]>();
    private Map<String, Class> cacheClass = new HashMap<String, Class>();

    public void addClass(String className, byte[] classByte) {
        this.classByteMap.put(className, classByte);
    }

    private void readJar(JarFile jar) throws IOException {
        Enumeration<JarEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            String clss;
            JarEntry je = en.nextElement();
            String name = je.getName();
            if (!name.endsWith(".class") || this.findLoadedClass(clss = name.replace(".class", "").replaceAll("/", ".")) != null) continue;
            InputStream input = jar.getInputStream(je);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bufferSize = 4096;
            byte[] buffer = new byte[bufferSize];
            int bytesNumRead = 0;
            while ((bytesNumRead = input.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesNumRead);
            }
            byte[] cc = baos.toByteArray();
            input.close();
            this.classByteMap.put(clss, cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.cacheClass.get(name);
            if (null != clazz) {
                return clazz;
            }
            try {
                clazz = this.findClass(name);
                if (null != clazz) {
                    this.cacheClass.put(name, clazz);
                } else {
                    clazz = super.loadClass(name, resolve);
                }
            }
            catch (ClassNotFoundException ex) {
                clazz = super.loadClass(name, resolve);
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] result = this.classByteMap.get(name);
        if (result == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(name, result, 0, result.length);
    }
}

