/*
 * Decompiled with CFR 0.152.
 */
package cn.safe6.controller;

import cn.safe6.controller.Controller;
import cn.safe6.core.ControllersFactory;
import cn.safe6.payload.JRMPClient;
import cn.safe6.util.HttpClientUtil;
import cn.safe6.util.HttpTool;
import cn.safe6.util.PayloadEncryptTool;
import cn.safe6.util.ShiroTool;
import cn.safe6.util.Tools;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;

public class JRMPTools {
    private final Map<String, Object> paramsContext = ControllersFactory.paramsContext;
    @FXML
    public TextField server;

    @FXML
    public void send(ActionEvent actionEvent) throws Exception {
        Controller controller = (Controller)ControllersFactory.controllers.get("Controller");
        controller.validAllDataAndSetConfig();
        String url = this.paramsContext.get("url").toString();
        if (this.paramsContext.get("key") == null) {
            Tools.alert("AES key \u4e0d\u80fd\u4e3a\u7a7a", "\u8bf7\u8f93\u5165AES key");
            return;
        }
        String key = this.paramsContext.get("key").toString();
        String aes = this.paramsContext.get("AES").toString();
        String method = this.paramsContext.get("method").toString();
        String rmeValue = this.paramsContext.get("rmeValue").toString();
        Map params = (Map)this.paramsContext.get("params");
        byte[] payload = JRMPClient.getPayload(this.server.getText());
        Map<String, Object> header = ShiroTool.getShiroHeader((Map)this.paramsContext.get("header"), rmeValue);
        String encryptData = "GCM".equals(aes) ? PayloadEncryptTool.AesGcmEncrypt(payload, key) : PayloadEncryptTool.AesCbcEncrypt(payload, key);
        header.put("cookie", rmeValue + "=" + encryptData);
        try {
            if (method.equals("GET")) {
                HttpTool.get(url, header);
            } else {
                HttpClientUtil.httpPostRequest(url, header, params);
            }
            Tools.info("\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            Tools.alert("\u53d1\u9001\u5931\u8d25", e.getMessage());
        }
    }
}

