/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.sasl;

import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.xnio.sasl.SaslClientWrapper;
import org.xnio.sasl.SaslServerWrapper;

public abstract class SaslWrapper {
    public abstract byte[] wrap(byte[] var1, int var2, int var3) throws SaslException;

    public final byte[] wrap(byte[] bytes2) throws SaslException {
        return this.unwrap(bytes2, 0, bytes2.length);
    }

    public abstract byte[] wrap(ByteBuffer var1) throws SaslException;

    public abstract byte[] unwrap(byte[] var1, int var2, int var3) throws SaslException;

    public final byte[] unwrap(byte[] bytes2) throws SaslException {
        return this.unwrap(bytes2, 0, bytes2.length);
    }

    public abstract byte[] unwrap(ByteBuffer var1) throws SaslException;

    public final void wrap(ByteBuffer destination, ByteBuffer source2) throws SaslException {
        destination.put(this.wrap(source2));
    }

    public final void unwrap(ByteBuffer destination, ByteBuffer source2) throws SaslException {
        destination.put(this.wrap(source2));
    }

    public static SaslWrapper create(SaslClient saslClient) {
        return new SaslClientWrapper(saslClient);
    }

    public static SaslWrapper create(SaslServer saslServer) {
        return new SaslServerWrapper(saslServer);
    }
}

