/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.xnio.FileChangeCallback;
import org.xnio.FileChangeEvent;
import org.xnio.FileSystemWatcher;
import org.xnio.IoUtils;
import org.xnio.nio.Log;

class WatchServiceFileSystemWatcher
implements FileSystemWatcher,
Runnable {
    private static final AtomicInteger threadIdCounter = new AtomicInteger(0);
    public static final String THREAD_NAME = "xnio-file-watcher";
    private WatchService watchService;
    private final Map<File, PathData> files = Collections.synchronizedMap(new HashMap());
    private final Map<WatchKey, PathData> pathDataByKey = Collections.synchronizedMap(new IdentityHashMap());
    private volatile boolean stopped = false;
    private final Thread watchThread;

    WatchServiceFileSystemWatcher(String name2, boolean daemon) {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.watchThread = new Thread((Runnable)this, "xnio-file-watcher[" + name2 + "]-" + threadIdCounter);
        this.watchThread.setDaemon(daemon);
        this.watchThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            try {
                WatchKey key2 = this.watchService.take();
                if (key2 == null) continue;
                try {
                    PathData pathData = this.pathDataByKey.get(key2);
                    if (pathData == null) continue;
                    ArrayList<FileChangeEvent> results = new ArrayList<FileChangeEvent>();
                    List<WatchEvent<?>> events = key2.pollEvents();
                    HashSet<File> addedFiles = new HashSet<File>();
                    HashSet<File> deletedFiles = new HashSet<File>();
                    for (WatchEvent<?> watchEvent : events) {
                        FileChangeEvent.Type type2;
                        Path eventPath = (Path)watchEvent.context();
                        File targetFile = ((Path)key2.watchable()).resolve(eventPath).toFile();
                        if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                            FileChangeEvent.Type type22 = FileChangeEvent.Type.ADDED;
                            addedFiles.add(targetFile);
                            if (targetFile.isDirectory()) {
                                try {
                                    this.addWatchedDirectory(pathData, targetFile);
                                }
                                catch (IOException e2) {
                                    Log.log.debugf((Throwable)e2, "Could not add watched directory %s", (Object)targetFile);
                                }
                            }
                        } else if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                            type2 = FileChangeEvent.Type.MODIFIED;
                        } else {
                            if (watchEvent.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                            type2 = FileChangeEvent.Type.REMOVED;
                            deletedFiles.add(targetFile);
                        }
                        results.add(new FileChangeEvent(targetFile, type2));
                    }
                    key2.pollEvents().clear();
                    Iterator it = results.iterator();
                    while (it.hasNext()) {
                        FileChangeEvent fileChangeEvent = (FileChangeEvent)it.next();
                        if (fileChangeEvent.getType() == FileChangeEvent.Type.MODIFIED) {
                            if (addedFiles.contains(fileChangeEvent.getFile()) && deletedFiles.contains(fileChangeEvent.getFile()) || !addedFiles.contains(fileChangeEvent.getFile()) && !deletedFiles.contains(fileChangeEvent.getFile())) continue;
                            it.remove();
                            continue;
                        }
                        if (fileChangeEvent.getType() == FileChangeEvent.Type.ADDED) {
                            if (!deletedFiles.contains(fileChangeEvent.getFile())) continue;
                            it.remove();
                            continue;
                        }
                        if (fileChangeEvent.getType() != FileChangeEvent.Type.REMOVED || !addedFiles.contains(fileChangeEvent.getFile())) continue;
                        it.remove();
                    }
                    if (results.isEmpty()) continue;
                    for (FileChangeCallback callback : pathData.callbacks) {
                        WatchServiceFileSystemWatcher.invokeCallback(callback, results);
                    }
                }
                finally {
                    if (key2.reset()) continue;
                    this.files.remove(key2.watchable());
                }
            }
            catch (InterruptedException key2) {
            }
            catch (ClosedWatchServiceException cwse) {
                break;
            }
        }
    }

    @Override
    public synchronized void watchPath(File file2, FileChangeCallback callback) {
        try {
            PathData data2 = this.files.get(file2);
            if (data2 == null) {
                Set<File> allDirectories = WatchServiceFileSystemWatcher.doScan(file2).keySet();
                Path path2 = Paths.get(file2.toURI());
                data2 = new PathData(path2);
                for (File dir2 : allDirectories) {
                    this.addWatchedDirectory(data2, dir2);
                }
                this.files.put(file2, data2);
            }
            data2.callbacks.add(callback);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void addWatchedDirectory(PathData data2, File dir2) throws IOException {
        Path path2 = Paths.get(dir2.toURI());
        WatchKey key2 = path2.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.pathDataByKey.put(key2, data2);
        data2.keys.add(key2);
    }

    @Override
    public synchronized void unwatchPath(File file2, FileChangeCallback callback) {
        PathData data2 = this.files.get(file2);
        if (data2 != null) {
            data2.callbacks.remove(callback);
            if (data2.callbacks.isEmpty()) {
                this.files.remove(file2);
                for (WatchKey key2 : data2.keys) {
                    key2.cancel();
                    this.pathDataByKey.remove(key2);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.stopped = true;
        this.watchThread.interrupt();
        IoUtils.safeClose((Closeable)this.watchService);
    }

    private static Map<File, Long> doScan(File file2) {
        HashMap<File, Long> results = new HashMap<File, Long>();
        ArrayDeque<File> toScan = new ArrayDeque<File>();
        toScan.add(file2);
        while (!toScan.isEmpty()) {
            File next2 = (File)toScan.pop();
            if (!next2.isDirectory()) continue;
            results.put(next2, next2.lastModified());
            File[] list = next2.listFiles();
            if (list == null) continue;
            for (File f : list) {
                toScan.push(new File(f.getAbsolutePath()));
            }
        }
        return results;
    }

    private static void invokeCallback(FileChangeCallback callback, List<FileChangeEvent> results) {
        try {
            callback.handleChanges(results);
        }
        catch (Exception e2) {
            Log.log.failedToInvokeFileWatchCallback(e2);
        }
    }

    private class PathData {
        final Path path;
        final List<FileChangeCallback> callbacks = new ArrayList<FileChangeCallback>();
        final List<WatchKey> keys = new ArrayList<WatchKey>();

        private PathData(Path path2) {
            this.path = path2;
        }
    }
}

