/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class BlockingStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private boolean resumed;

    public BlockingStreamSourceConduit(StreamSourceConduit next2) {
        super(next2);
    }

    @Override
    public long transferTo(long position, long count2, FileChannel target) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSourceConduit)this.next).transferTo(position, count2, target);
        }
        while ((res = ((StreamSourceConduit)this.next).transferTo(position, count2, target)) == 0L) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
        return res;
    }

    @Override
    public long transferTo(long count2, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSourceConduit)this.next).transferTo(count2, throughBuffer, target);
        }
        while ((res = ((StreamSourceConduit)this.next).transferTo(count2, throughBuffer, target)) == 0L && !throughBuffer.hasRemaining()) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
        return res;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int res;
        if (this.resumed) {
            return ((StreamSourceConduit)this.next).read(dst);
        }
        while ((res = ((StreamSourceConduit)this.next).read(dst)) == 0) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSourceConduit)this.next).read(dsts, offs, len);
        }
        while ((res = ((StreamSourceConduit)this.next).read(dsts, offs, len)) == 0L) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
        return res;
    }

    @Override
    public void resumeReads() {
        this.resumed = true;
        ((StreamSourceConduit)this.next).resumeReads();
    }

    @Override
    public void wakeupReads() {
        this.resumed = true;
        ((StreamSourceConduit)this.next).wakeupReads();
    }

    @Override
    public void suspendReads() {
        this.resumed = false;
        ((StreamSourceConduit)this.next).suspendReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.resumed;
    }
}

