/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public final class BlockingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private boolean resumed;

    public BlockingStreamSinkConduit(StreamSinkConduit next2) {
        super(next2);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count2) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSinkConduit)this.next).transferFrom(src, position, count2);
        }
        while ((res = ((StreamSinkConduit)this.next).transferFrom(src, position, count2)) == 0L) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return res;
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count2, ByteBuffer throughBuffer) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSinkConduit)this.next).transferFrom(source2, count2, throughBuffer);
        }
        while ((res = ((StreamSinkConduit)this.next).transferFrom(source2, count2, throughBuffer)) == 0L) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return res;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.write(src, false);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        return this.write(srcs, offs, len, false);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return this.write(src, true);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.write(srcs, offset, length, true);
    }

    private int write(ByteBuffer src, boolean writeFinal) throws IOException {
        int res;
        if (this.resumed) {
            return this.doWrite(src, writeFinal);
        }
        while ((long)(res = this.doWrite(src, writeFinal)) == 0L) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return res;
    }

    private long write(ByteBuffer[] srcs, int offs, int len, boolean writeFinal) throws IOException {
        long res;
        if (this.resumed) {
            return this.doWrite(srcs, offs, len, writeFinal);
        }
        while ((res = ((StreamSinkConduit)this.next).write(srcs, offs, len)) == 0L) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return res;
    }

    private int doWrite(ByteBuffer src, boolean writeFinal) throws IOException {
        if (writeFinal) {
            return ((StreamSinkConduit)this.next).writeFinal(src);
        }
        return ((StreamSinkConduit)this.next).write(src);
    }

    private long doWrite(ByteBuffer[] srcs, int offs, int len, boolean writeFinal) throws IOException {
        if (writeFinal) {
            return ((StreamSinkConduit)this.next).writeFinal(srcs, offs, len);
        }
        return ((StreamSinkConduit)this.next).write(srcs, offs, len);
    }

    @Override
    public boolean flush() throws IOException {
        if (this.resumed) {
            return ((StreamSinkConduit)this.next).flush();
        }
        while (!((StreamSinkConduit)this.next).flush()) {
            ((StreamSinkConduit)this.next).awaitWritable();
        }
        return true;
    }

    @Override
    public void resumeWrites() {
        this.resumed = true;
        ((StreamSinkConduit)this.next).resumeWrites();
    }

    @Override
    public void suspendWrites() {
        this.resumed = false;
        ((StreamSinkConduit)this.next).suspendWrites();
    }

    @Override
    public void wakeupWrites() {
        this.resumed = true;
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.resumed;
    }
}

