/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WriteListenerSettable;

public final class SplitStreamSinkChannel
implements StreamSinkChannel,
WriteListenerSettable<SplitStreamSinkChannel>,
CloseListenerSettable<SplitStreamSinkChannel> {
    private final StreamSinkChannel delegate;
    private volatile int state;
    private ChannelListener<? super SplitStreamSinkChannel> writeListener;
    private ChannelListener<? super SplitStreamSinkChannel> closeListener;
    private static final int FLAG_DELEGATE_CONFIG = 1;
    private static final int FLAG_CLOSE_REQ = 2;
    private static final int FLAG_CLOSE_COMP = 4;
    private static final AtomicIntegerFieldUpdater<SplitStreamSinkChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(SplitStreamSinkChannel.class, "state");

    public SplitStreamSinkChannel(StreamSinkChannel delegate, boolean delegateConfig) {
        this.delegate = delegate;
        this.state = delegateConfig ? 1 : 0;
        delegate.getWriteSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<StreamSinkChannel>(){

            @Override
            public void handleEvent(StreamSinkChannel channel) {
                ChannelListeners.invokeChannelListener(SplitStreamSinkChannel.this, SplitStreamSinkChannel.this.writeListener);
            }
        });
    }

    public SplitStreamSinkChannel(StreamSinkChannel delegate) {
        this(delegate, false);
    }

    @Override
    public void setWriteListener(ChannelListener<? super SplitStreamSinkChannel> writeListener) {
        this.writeListener = writeListener;
    }

    @Override
    public ChannelListener<? super SplitStreamSinkChannel> getWriteListener() {
        return this.writeListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super SplitStreamSinkChannel> closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    public ChannelListener<? super SplitStreamSinkChannel> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<? extends SplitStreamSinkChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<SplitStreamSinkChannel>(this);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return this.delegate.writeFinal(src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.writeFinal(srcs, offset, length);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return this.delegate.writeFinal(srcs);
    }

    public ChannelListener.Setter<? extends SplitStreamSinkChannel> getWriteSetter() {
        return new WriteListenerSettable.Setter<SplitStreamSinkChannel>(this);
    }

    @Override
    public void shutdownWrites() throws IOException {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet(oldVal = this.state, 2)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 2));
        this.delegate.shutdownWrites();
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 2);
    }

    @Override
    public void close() throws IOException {
        this.shutdownWrites();
        this.flush();
    }

    @Override
    public boolean flush() throws IOException {
        int newVal;
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 4)) {
            return true;
        }
        boolean flushed = this.delegate.flush();
        if (!flushed) {
            return false;
        }
        do {
            if (!Bits.allAreClear(oldVal, 2)) continue;
            return true;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 4));
        ChannelListeners.invokeChannelListener(this, this.closeListener);
        return true;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count2) throws IOException {
        return this.delegate.transferFrom(src, position, count2);
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count2, ByteBuffer throughBuffer) throws IOException {
        return this.delegate.transferFrom(source2, count2, throughBuffer);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.write(srcs, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.delegate.write(srcs);
    }

    @Override
    public void suspendWrites() {
        this.delegate.suspendWrites();
    }

    @Override
    public void resumeWrites() {
        this.delegate.resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.delegate.isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        this.delegate.wakeupWrites();
    }

    @Override
    public void awaitWritable() throws IOException {
        this.delegate.awaitWritable();
    }

    @Override
    public void awaitWritable(long time2, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitWritable(time2, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return Bits.allAreSet(this.state, 1) ? (T)this.delegate.setOption(option, value) : null;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return Bits.allAreSet(this.state, 1) ? (T)this.delegate.getOption(option) : null;
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return Bits.allAreSet(this.state, 1) ? this.delegate.supportsOption(option) : false;
    }
}

