/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xnio.AutomaticReference;
import org.xnio.BufferAllocator;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.ReadPropertyAction;
import org.xnio._private.Messages;

public final class ByteBufferSlicePool
implements Pool<ByteBuffer> {
    private static final int LOCAL_LENGTH;
    private static final Queue<ByteBuffer> FREE_DIRECT_BUFFERS;
    private final Set<Ref> refSet = Collections.synchronizedSet(new HashSet());
    private final Queue<Slice> sliceQueue;
    private final BufferAllocator<ByteBuffer> allocator;
    private final int bufferSize;
    private final int buffersPerRegion;
    private final int threadLocalQueueSize;
    private final List<ByteBuffer> directBuffers;
    private final ThreadLocal<ThreadLocalCache> localQueueHolder = new ThreadLocalCacheWrapper(this);

    public ByteBufferSlicePool(BufferAllocator<ByteBuffer> allocator, int bufferSize, int maxRegionSize, int threadLocalQueueSize) {
        if (bufferSize <= 0) {
            throw Messages.msg.parameterOutOfRange("bufferSize");
        }
        if (maxRegionSize < bufferSize) {
            throw Messages.msg.parameterOutOfRange("bufferSize");
        }
        this.buffersPerRegion = maxRegionSize / bufferSize;
        this.bufferSize = bufferSize;
        this.allocator = allocator;
        this.sliceQueue = new ConcurrentLinkedQueue<Slice>();
        this.threadLocalQueueSize = threadLocalQueueSize;
        this.directBuffers = allocator == BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR ? Collections.synchronizedList(new ArrayList()) : null;
    }

    public ByteBufferSlicePool(BufferAllocator<ByteBuffer> allocator, int bufferSize, int maxRegionSize) {
        this(allocator, bufferSize, maxRegionSize, LOCAL_LENGTH);
    }

    public ByteBufferSlicePool(int bufferSize, int maxRegionSize) {
        this(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, bufferSize, maxRegionSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pooled<ByteBuffer> allocate() {
        Queue<Slice> sliceQueue;
        Slice slice;
        if (this.threadLocalQueueSize > 0) {
            ThreadLocalCache localCache = this.localQueueHolder.get();
            if (localCache.outstanding != this.threadLocalQueueSize) {
                ++localCache.outstanding;
            }
            if ((slice = localCache.queue.poll()) != null) {
                return new PooledByteBuffer(slice, slice.slice());
            }
        }
        if ((slice = (sliceQueue = this.sliceQueue).poll()) != null) {
            return new PooledByteBuffer(slice, slice.slice());
        }
        Queue<Slice> queue = sliceQueue;
        synchronized (queue) {
            slice = sliceQueue.poll();
            if (slice != null) {
                return new PooledByteBuffer(slice, slice.slice());
            }
            Slice newSlice = this.allocateSlices(this.buffersPerRegion, this.bufferSize);
            return new PooledByteBuffer(newSlice, newSlice.slice());
        }
    }

    private Slice allocateSlices(int buffersPerRegion, int bufferSize) {
        if (this.directBuffers != null) {
            ByteBuffer region = FREE_DIRECT_BUFFERS.poll();
            if (region != null) {
                return this.sliceReusedBuffer(region, buffersPerRegion, bufferSize);
            }
            region = this.allocator.allocate(buffersPerRegion * bufferSize);
            return this.sliceAllocatedBuffer(region, buffersPerRegion, bufferSize);
        }
        return this.sliceAllocatedBuffer(this.allocator.allocate(buffersPerRegion * bufferSize), buffersPerRegion, bufferSize);
    }

    private Slice sliceReusedBuffer(ByteBuffer region, int buffersPerRegion, int bufferSize) {
        int maxI = Math.min(buffersPerRegion, region.capacity() / bufferSize);
        int idx = bufferSize;
        for (int i = 1; i < maxI; ++i) {
            this.sliceQueue.add(new Slice(region, idx, bufferSize));
            idx += bufferSize;
        }
        if (maxI == 0) {
            return this.allocateSlices(buffersPerRegion, bufferSize);
        }
        if (maxI < buffersPerRegion) {
            this.sliceQueue.add(this.allocateSlices(buffersPerRegion - maxI, bufferSize));
        }
        return new Slice(region, 0, bufferSize);
    }

    private Slice sliceAllocatedBuffer(ByteBuffer region, int buffersPerRegion, int bufferSize) {
        int idx = bufferSize;
        for (int i = 1; i < buffersPerRegion; ++i) {
            this.sliceQueue.add(new Slice(region, idx, bufferSize));
            idx += bufferSize;
        }
        return new Slice(region, 0, bufferSize);
    }

    public void clean() {
        ThreadLocalCache localCache = this.localQueueHolder.get();
        if (!localCache.queue.isEmpty()) {
            localCache.queue.clear();
        }
        if (!this.sliceQueue.isEmpty()) {
            this.sliceQueue.clear();
        }
        FREE_DIRECT_BUFFERS.addAll(this.directBuffers);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    private ThreadLocalCache createThreadLocalCache() {
        return new ThreadLocalCache(this);
    }

    private void freeThreadLocalCache(ThreadLocalCache cache) {
        ArrayDeque<Slice> deque = cache.queue;
        Slice slice = deque.poll();
        while (slice != null) {
            this.doFree(slice);
            slice = deque.poll();
        }
    }

    private void doFree(Slice region) {
        if (this.threadLocalQueueSize > 0) {
            ArrayDeque<Slice> localQueue;
            ThreadLocalCache localCache = this.localQueueHolder.get();
            boolean cacheOk = false;
            if (localCache.outstanding > 0) {
                --localCache.outstanding;
                cacheOk = true;
            }
            if ((localQueue = localCache.queue).size() == this.threadLocalQueueSize || !cacheOk) {
                this.sliceQueue.add(region);
            } else {
                localQueue.add(region);
            }
        } else {
            this.sliceQueue.add(region);
        }
    }

    static {
        int val2;
        String value = AccessController.doPrivileged(new ReadPropertyAction("xnio.bufferpool.threadlocal.size", "12"));
        try {
            val2 = Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            val2 = 12;
        }
        LOCAL_LENGTH = val2;
        FREE_DIRECT_BUFFERS = new ConcurrentLinkedQueue<ByteBuffer>();
    }

    private static class ThreadLocalCacheWrapper
    extends ThreadLocal<ThreadLocalCache> {
        private final WeakReference<ByteBufferSlicePool> pool;

        ThreadLocalCacheWrapper(ByteBufferSlicePool pool) {
            this.pool = new WeakReference<ByteBufferSlicePool>(pool);
        }

        @Override
        protected ThreadLocalCache initialValue() {
            ByteBufferSlicePool pool = (ByteBufferSlicePool)this.pool.get();
            if (pool != null) {
                return pool.createThreadLocalCache();
            }
            return null;
        }

        @Override
        public void remove() {
            ByteBufferSlicePool pool = (ByteBufferSlicePool)this.pool.get();
            ThreadLocalCache cache = (ThreadLocalCache)this.get();
            if (pool != null && cache != null) {
                pool.freeThreadLocalCache(cache);
            }
            super.remove();
        }
    }

    static final class ThreadLocalCache {
        final WeakReference<ByteBufferSlicePool> pool;
        final ArrayDeque<Slice> queue;
        int outstanding = 0;

        ThreadLocalCache(ByteBufferSlicePool pool) {
            this.pool = new WeakReference<ByteBufferSlicePool>(pool);
            this.queue = new ArrayDeque<Slice>(pool.threadLocalQueueSize){

                protected void finalize() {
                    ByteBufferSlicePool pool = (ByteBufferSlicePool)pool.get();
                    if (pool == null) {
                        return;
                    }
                    ArrayDeque<Slice> deque = queue;
                    Slice slice = deque.poll();
                    while (slice != null) {
                        pool.doFree(slice);
                        slice = deque.poll();
                    }
                }
            };
        }
    }

    final class Ref
    extends AutomaticReference<ByteBuffer> {
        private final Slice region;

        private Ref(ByteBuffer referent, Slice region) {
            super(referent, AutomaticReference.PERMIT);
            this.region = region;
        }

        @Override
        protected void free() {
            ByteBufferSlicePool.this.doFree(this.region);
            ByteBufferSlicePool.this.refSet.remove(this);
        }
    }

    private static final class Slice {
        private final ByteBuffer parent;

        private Slice(ByteBuffer parent, int start, int size) {
            this.parent = (ByteBuffer)parent.duplicate().position(start).limit(start + size);
        }

        ByteBuffer slice() {
            return this.parent.slice();
        }
    }

    private final class PooledByteBuffer
    implements Pooled<ByteBuffer> {
        private final Slice region;
        ByteBuffer buffer;

        PooledByteBuffer(Slice region, ByteBuffer buffer) {
            this.region = region;
            this.buffer = buffer;
        }

        @Override
        public void discard() {
            ByteBuffer buffer = this.buffer;
            this.buffer = null;
            if (buffer != null) {
                ByteBufferSlicePool.this.refSet.add(new Ref(buffer, this.region));
            }
        }

        @Override
        public void free() {
            ByteBuffer buffer = this.buffer;
            this.buffer = null;
            if (buffer != null) {
                ByteBufferSlicePool.this.doFree(this.region);
            }
        }

        @Override
        public ByteBuffer getResource() {
            ByteBuffer buffer = this.buffer;
            if (buffer == null) {
                throw Messages.msg.bufferFreed();
            }
            return buffer;
        }

        @Override
        public void close() {
            this.free();
        }

        public String toString() {
            return "Pooled buffer " + this.buffer;
        }
    }
}

