/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.rpc;

import java.util.Arrays;

final class IdentityIntMap<T>
implements Cloneable {
    private int[] values;
    private Object[] keys;
    private int count;
    private int resizeCount;

    public IdentityIntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity must be > 0");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0.0 and < 1.0");
        }
        if (initialCapacity < 16) {
            initialCapacity = 16;
        } else {
            int c = Integer.highestOneBit(initialCapacity) - 1;
            initialCapacity = Integer.highestOneBit(initialCapacity + c);
        }
        this.keys = new Object[initialCapacity];
        this.values = new int[initialCapacity];
        this.resizeCount = (int)((double)initialCapacity * (double)loadFactor);
    }

    public IdentityIntMap<T> clone() {
        try {
            IdentityIntMap clone = (IdentityIntMap)super.clone();
            clone.values = (int[])this.values.clone();
            clone.keys = (Object[])this.keys.clone();
            return clone;
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException();
        }
    }

    public IdentityIntMap(float loadFactor) {
        this(64, loadFactor);
    }

    public IdentityIntMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public IdentityIntMap() {
        this(0.5f);
    }

    public int get(T key2, int defVal) {
        Object[] keys2 = this.keys;
        int mask = keys2.length - 1;
        int hc = System.identityHashCode(key2) & mask;
        Object v;
        while ((v = keys2[hc]) != key2) {
            if (v == null) {
                return defVal;
            }
            hc = hc + 1 & mask;
        }
        return this.values[hc];
    }

    public void put(T key2, int value) {
        int hc;
        Object[] keys2 = this.keys;
        int mask = keys2.length - 1;
        int[] values = this.values;
        int idx = hc = System.identityHashCode(key2) & mask;
        while (true) {
            Object v;
            if ((v = keys2[idx]) == null) {
                keys2[idx] = key2;
                values[idx] = value;
                if (++this.count > this.resizeCount) {
                    this.resize();
                }
                return;
            }
            if (v == key2) {
                values[idx] = value;
                return;
            }
            idx = hc++ & mask;
        }
    }

    private void resize() {
        Object[] oldKeys = this.keys;
        int oldsize = oldKeys.length;
        int[] oldValues = this.values;
        if (oldsize >= 0x40000000) {
            throw new IllegalStateException("Table full");
        }
        int newsize = oldsize << 1;
        int mask = newsize - 1;
        Object[] newKeys = new Object[newsize];
        int[] newValues = new int[newsize];
        this.keys = newKeys;
        this.values = newValues;
        if ((this.resizeCount <<= 1) == 0) {
            this.resizeCount = Integer.MAX_VALUE;
        }
        block0: for (int oi = 0; oi < oldsize; ++oi) {
            Object key2 = oldKeys[oi];
            if (key2 == null) continue;
            int ni = System.identityHashCode(key2) & mask;
            while (true) {
                Object v;
                if ((v = newKeys[ni]) == null) {
                    newKeys[ni] = key2;
                    newValues[ni] = oldValues[oi];
                    continue block0;
                }
                ni = ni + 1 & mask;
            }
        }
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        this.count = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Map length = ").append(this.keys.length).append(", count = ").append(this.count).append(", resize count = ").append(this.resizeCount).append('\n');
        for (int i = 0; i < this.keys.length; ++i) {
            builder.append('[').append(i).append("] = ");
            if (this.keys[i] != null) {
                int hc = System.identityHashCode(this.keys[i]);
                builder.append("{ ").append(this.keys[i]).append(" (hash ").append(hc).append(", modulus ").append(hc % this.keys.length).append(") => ").append(this.values[i]).append(" }");
            } else {
                builder.append("(blank)");
            }
            builder.append('\n');
        }
        return builder.toString();
    }
}

