/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.net;

import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.regex.Pattern;
import org.wildfly.common.net.HostName;

final class GetHostInfoAction
implements PrivilegedAction<String[]> {
    GetHostInfoAction() {
    }

    @Override
    public String[] run() {
        String qualifiedHostName = System.getProperty("jboss.qualified.host.name");
        String providedHostName = System.getProperty("jboss.host.name");
        String providedNodeName = System.getProperty("jboss.node.name");
        if (qualifiedHostName == null) {
            qualifiedHostName = providedHostName;
            if (qualifiedHostName == null) {
                qualifiedHostName = System.getenv("HOSTNAME");
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = System.getenv("COMPUTERNAME");
            }
            if (qualifiedHostName == null) {
                try {
                    qualifiedHostName = HostName.getLocalHost().getHostName();
                }
                catch (UnknownHostException e2) {
                    qualifiedHostName = null;
                }
            }
            if (qualifiedHostName != null && Pattern.compile("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:").matcher(qualifiedHostName).find()) {
                qualifiedHostName = null;
            }
            qualifiedHostName = qualifiedHostName == null ? "unknown-host.unknown-domain" : qualifiedHostName.trim().toLowerCase();
        }
        if (providedHostName == null) {
            int idx = qualifiedHostName.indexOf(46);
            String string2 = providedHostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
        }
        if (providedNodeName == null) {
            providedNodeName = providedHostName;
        }
        return new String[]{providedHostName, qualifiedHostName, providedNodeName};
    }
}

