/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import org.wildfly.common.iteration.CodePointIterator;

final class SkippingCodePointIterator
extends CodePointIterator {
    private final CodePointIterator iter;
    private final IntPredicate predicate;

    SkippingCodePointIterator(CodePointIterator iter, IntPredicate predicate) {
        this.iter = iter;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext() && !this.skip(this.peekNext());
    }

    @Override
    public boolean hasPrevious() {
        return this.iter.hasPrevious() && !this.skip(this.peekPrevious());
    }

    @Override
    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iter.next();
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.iter.hasNext()) {
            throw new NoSuchElementException();
        }
        int next2 = this.seekNext(this.iter.peekNext());
        if (!this.skip(next2)) {
            return next2;
        }
        return next2;
    }

    private int seekNext(int next2) throws NoSuchElementException {
        if (!this.iter.hasNext()) {
            return next2;
        }
        next2 = this.iter.next();
        if (this.skip(next2)) {
            return this.seekNext(next2);
        }
        this.iter.previous();
        return next2;
    }

    @Override
    public int previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.iter.previous();
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.iter.hasPrevious()) {
            throw new NoSuchElementException();
        }
        int prev2 = this.seekPrev(this.iter.peekPrevious());
        if (!this.skip(prev2)) {
            return prev2;
        }
        return prev2;
    }

    private int seekPrev(int prev2) throws NoSuchElementException {
        if (!this.iter.hasPrevious()) {
            return prev2;
        }
        prev2 = this.iter.previous();
        if (this.skip(prev2)) {
            return this.seekPrev(prev2);
        }
        this.iter.next();
        return prev2;
    }

    @Override
    public long getIndex() {
        return this.iter.getIndex();
    }

    private boolean skip(int c) {
        return this.predicate.test(c);
    }
}

