/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.archive;

import java.util.Arrays;
import org.wildfly.common.archive.Index;

final class TinyIndex
extends Index {
    private final short[] table;

    TinyIndex(int entries) {
        super(entries);
        short[] array2 = new short[this.size()];
        Arrays.fill(array2, (short)-1);
        this.table = array2;
    }

    @Override
    long get(int index2) {
        short val2 = this.table[index2];
        return val2 == -1 ? -1L : (long)(val2 & 0xFFFF);
    }

    @Override
    void put(int index2, long offset) {
        short[] table = this.table;
        short val2 = table[index2];
        while ((long)val2 != -1L) {
            index2 = index2 + 1 & this.getMask();
            val2 = table[index2];
        }
        table[index2] = (short)offset;
    }
}

