/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.archive;

import java.util.Arrays;
import org.wildfly.common.archive.Index;

final class LargeIndex
extends Index {
    private final int[] table;

    LargeIndex(int entries) {
        super(entries);
        int[] array2 = new int[this.size()];
        Arrays.fill(array2, -1);
        this.table = array2;
    }

    @Override
    long get(int index2) {
        int val2 = this.table[index2];
        return val2 == -1 ? -1L : (long)(val2 & 0xFFFFFFFF);
    }

    @Override
    void put(int index2, long offset) {
        int[] table = this.table;
        int val2 = table[index2];
        while ((long)val2 != -1L) {
            index2 = index2 + 1 & this.getMask();
            val2 = table[index2];
        }
        table[index2] = Math.toIntExact(offset);
    }
}

