/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;

public class AnnotationConfigWebApplicationContext
extends AbstractRefreshableWebApplicationContext
implements AnnotationConfigRegistry {
    private BeanNameGenerator beanNameGenerator;
    private ScopeMetadataResolver scopeMetadataResolver;
    private final Set<Class<?>> annotatedClasses = new LinkedHashSet();
    private final Set<String> basePackages = new LinkedHashSet<String>();

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    protected BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver;
    }

    protected ScopeMetadataResolver getScopeMetadataResolver() {
        return this.scopeMetadataResolver;
    }

    @Override
    public void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty(annotatedClasses, "At least one annotated class must be specified");
        this.annotatedClasses.addAll(Arrays.asList(annotatedClasses));
    }

    @Override
    public void scan(String ... basePackages) {
        Assert.notEmpty(basePackages, "At least one base package must be specified");
        this.basePackages.addAll(Arrays.asList(basePackages));
    }

    @Override
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        String[] configLocations;
        AnnotatedBeanDefinitionReader reader2 = new AnnotatedBeanDefinitionReader(beanFactory);
        reader2.setEnvironment(this.getEnvironment());
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(beanFactory);
        scanner.setEnvironment(this.getEnvironment());
        BeanNameGenerator beanNameGenerator = this.getBeanNameGenerator();
        ScopeMetadataResolver scopeMetadataResolver = this.getScopeMetadataResolver();
        if (beanNameGenerator != null) {
            reader2.setBeanNameGenerator(beanNameGenerator);
            scanner.setBeanNameGenerator(beanNameGenerator);
            beanFactory.registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", beanNameGenerator);
        }
        if (scopeMetadataResolver != null) {
            reader2.setScopeMetadataResolver(scopeMetadataResolver);
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
        if (!this.annotatedClasses.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Registering annotated classes: [" + StringUtils.collectionToCommaDelimitedString(this.annotatedClasses) + "]");
            }
            reader2.register(this.annotatedClasses.toArray(new Class[this.annotatedClasses.size()]));
        }
        if (!this.basePackages.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Scanning base packages: [" + StringUtils.collectionToCommaDelimitedString(this.basePackages) + "]");
            }
            scanner.scan(this.basePackages.toArray(new String[this.basePackages.size()]));
        }
        if ((configLocations = this.getConfigLocations()) != null) {
            for (String configLocation : configLocations) {
                try {
                    Class<?> clazz = this.getClassLoader().loadClass(configLocation);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Successfully resolved class for [" + configLocation + "]");
                    }
                    reader2.register(clazz);
                }
                catch (ClassNotFoundException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Could not load class for config location [" + configLocation + "] - trying package scan. " + ex);
                    }
                    int count2 = scanner.scan(configLocation);
                    if (!this.logger.isInfoEnabled()) continue;
                    if (count2 == 0) {
                        this.logger.info("No annotated classes found for specified class/package [" + configLocation + "]");
                        continue;
                    }
                    this.logger.info("Found " + count2 + " annotated classes in package [" + configLocation + "]");
                }
            }
        }
    }
}

