/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class StringUtils {
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';

    public static boolean isEmpty(Object str2) {
        return str2 == null || "".equals(str2);
    }

    public static boolean hasLength(CharSequence str2) {
        return str2 != null && str2.length() > 0;
    }

    public static boolean hasLength(String str2) {
        return StringUtils.hasLength((CharSequence)str2);
    }

    public static boolean hasText(CharSequence str2) {
        if (!StringUtils.hasLength(str2)) {
            return false;
        }
        int strLen = str2.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str2) {
        return StringUtils.hasText((CharSequence)str2);
    }

    public static boolean containsWhitespace(CharSequence str2) {
        if (!StringUtils.hasLength(str2)) {
            return false;
        }
        int strLen = str2.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str2) {
        return StringUtils.containsWhitespace((CharSequence)str2);
    }

    public static String trimWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimAllWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        int len = str2.length();
        StringBuilder sb = new StringBuilder(str2.length());
        for (int i = 0; i < len; ++i) {
            char c = str2.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str2) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str2, char leadingCharacter) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str2, char trailingCharacter) {
        if (!StringUtils.hasLength(str2)) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str2, String prefix) {
        if (str2 == null || prefix == null) {
            return false;
        }
        if (str2.startsWith(prefix)) {
            return true;
        }
        if (str2.length() < prefix.length()) {
            return false;
        }
        String lcStr = str2.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static boolean endsWithIgnoreCase(String str2, String suffix) {
        if (str2 == null || suffix == null) {
            return false;
        }
        if (str2.endsWith(suffix)) {
            return true;
        }
        if (str2.length() < suffix.length()) {
            return false;
        }
        String lcStr = str2.substring(str2.length() - suffix.length()).toLowerCase();
        String lcSuffix = suffix.toLowerCase();
        return lcStr.equals(lcSuffix);
    }

    public static boolean substringMatch(CharSequence str2, int index2, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index2 + j;
            if (i < str2.length() && str2.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static int countOccurrencesOf(String str2, String sub) {
        int idx;
        if (str2 == null || sub == null || str2.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count2 = 0;
        int pos = 0;
        while ((idx = str2.indexOf(sub, pos)) != -1) {
            ++count2;
            pos = idx + sub.length();
        }
        return count2;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index2 = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index2 >= 0) {
            sb.append(inString.substring(pos, index2));
            sb.append(newPattern);
            pos = index2 + patLen;
            index2 = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return StringUtils.replace(inString, pattern, "");
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String quote(String str2) {
        return str2 != null ? "'" + str2 + "'" : null;
    }

    public static Object quoteIfString(Object obj) {
        return obj instanceof String ? StringUtils.quote((String)obj) : obj;
    }

    public static String unqualify(String qualifiedName) {
        return StringUtils.unqualify(qualifiedName, '.');
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    public static String capitalize(String str2) {
        return StringUtils.changeFirstCharacterCase(str2, true);
    }

    public static String uncapitalize(String str2) {
        return StringUtils.changeFirstCharacterCase(str2, false);
    }

    private static String changeFirstCharacterCase(String str2, boolean capitalize2) {
        if (str2 == null || str2.length() == 0) {
            return str2;
        }
        StringBuilder sb = new StringBuilder(str2.length());
        if (capitalize2) {
            sb.append(Character.toUpperCase(str2.charAt(0)));
        } else {
            sb.append(Character.toLowerCase(str2.charAt(0)));
        }
        sb.append(str2.substring(1));
        return sb.toString();
    }

    public static String getFilename(String path2) {
        if (path2 == null) {
            return null;
        }
        int separatorIndex = path2.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path2.substring(separatorIndex + 1) : path2;
    }

    public static String getFilenameExtension(String path2) {
        if (path2 == null) {
            return null;
        }
        int extIndex = path2.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path2.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return null;
        }
        return path2.substring(extIndex + 1);
    }

    public static String stripFilenameExtension(String path2) {
        if (path2 == null) {
            return null;
        }
        int extIndex = path2.lastIndexOf(46);
        if (extIndex == -1) {
            return path2;
        }
        int folderIndex = path2.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return path2;
        }
        return path2.substring(0, extIndex);
    }

    public static String applyRelativePath(String path2, String relativePath) {
        int separatorIndex = path2.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path2.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = newPath + FOLDER_SEPARATOR;
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path2) {
        int i;
        if (path2 == null) {
            return null;
        }
        String pathToUse = StringUtils.replace(path2, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains(FOLDER_SEPARATOR)) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + StringUtils.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static boolean pathEquals(String path1, String path2) {
        return StringUtils.cleanPath(path1).equals(StringUtils.cleanPath(path2));
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = StringUtils.tokenizeToStringArray(localeString, "_ ", false, false);
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        StringUtils.validateLocalePart(language);
        StringUtils.validateLocalePart(country);
        String variant = "";
        if (parts.length > 2 && (variant = StringUtils.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country, language.length()) + country.length()))).startsWith("_")) {
            variant = StringUtils.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static void validateLocalePart(String localePart) {
        for (int i = 0; i < localePart.length(); ++i) {
            char ch = localePart.charAt(i);
            if (ch == '_' || ch == ' ' || Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
        }
    }

    public static String toLanguageTag(Locale locale) {
        return locale.getLanguage() + (StringUtils.hasText(locale.getCountry()) ? "-" + locale.getCountry() : "");
    }

    public static TimeZone parseTimeZoneString(String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        if ("GMT".equals(timeZone.getID()) && !timeZoneString.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + timeZoneString + "'");
        }
        return timeZone;
    }

    public static String[] addStringToArray(String[] array2, String str2) {
        if (ObjectUtils.isEmpty(array2)) {
            return new String[]{str2};
        }
        String[] newArr = new String[array2.length + 1];
        System.arraycopy(array2, 0, newArr, 0, array2.length);
        newArr[array2.length] = str2;
        return newArr;
    }

    public static String[] concatenateStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        String[] newArr = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArr, 0, array1.length);
        System.arraycopy(array2, 0, newArr, array1.length, array2.length);
        return newArr;
    }

    public static String[] mergeStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty(array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty(array2)) {
            return array1;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(array1));
        for (String str2 : array2) {
            if (result.contains(str2)) continue;
            result.add(str2);
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] sortStringArray(String[] array2) {
        if (ObjectUtils.isEmpty(array2)) {
            return new String[0];
        }
        Arrays.sort(array2);
        return array2;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<String> list = Collections.list(enumeration);
        return list.toArray(new String[list.size()]);
    }

    public static String[] trimArrayElements(String[] array2) {
        if (ObjectUtils.isEmpty(array2)) {
            return new String[0];
        }
        String[] result = new String[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            String element = array2[i];
            result[i] = element != null ? element.trim() : null;
        }
        return result;
    }

    public static String[] removeDuplicateStrings(String[] array2) {
        if (ObjectUtils.isEmpty(array2)) {
            return array2;
        }
        LinkedHashSet<String> set2 = new LinkedHashSet<String>();
        for (String element : array2) {
            set2.add(element);
        }
        return StringUtils.toStringArray(set2);
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!StringUtils.hasLength(toSplit) || !StringUtils.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static Properties splitArrayElementsIntoProperties(String[] array2, String delimiter) {
        return StringUtils.splitArrayElementsIntoProperties(array2, delimiter, null);
    }

    public static Properties splitArrayElementsIntoProperties(String[] array2, String delimiter, String charsToDelete) {
        if (ObjectUtils.isEmpty(array2)) {
            return null;
        }
        Properties result = new Properties();
        for (String element : array2) {
            String[] splittedElement;
            if (charsToDelete != null) {
                element = StringUtils.deleteAny(element, charsToDelete);
            }
            if ((splittedElement = StringUtils.split(element, delimiter)) == null) continue;
            result.setProperty(splittedElement[0].trim(), splittedElement[1].trim());
        }
        return result;
    }

    public static String[] tokenizeToStringArray(String str2, String delimiters) {
        return StringUtils.tokenizeToStringArray(str2, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str2, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str2, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] delimitedListToStringArray(String str2, String delimiter) {
        return StringUtils.delimitedListToStringArray(str2, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str2, String delimiter, String charsToDelete) {
        if (str2 == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str2};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str2.length(); ++i) {
                result.add(StringUtils.deleteAny(str2.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str2.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str2.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str2.length() > 0 && pos <= str2.length()) {
                result.add(StringUtils.deleteAny(str2.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(String str2) {
        return StringUtils.delimitedListToStringArray(str2, ",");
    }

    public static Set<String> commaDelimitedListToSet(String str2) {
        String[] tokens;
        LinkedHashSet<String> set2 = new LinkedHashSet<String>();
        for (String token : tokens = StringUtils.commaDelimitedListToStringArray(str2)) {
            set2.add(token);
        }
        return set2;
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (CollectionUtils.isEmpty(coll)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (ObjectUtils.isEmpty(arr)) {
            return "";
        }
        if (arr.length == 1) {
            return ObjectUtils.nullSafeToString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return StringUtils.arrayToDelimitedString(arr, ",");
    }
}

