/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class Log4jConfigurer {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String XML_FILE_EXTENSION = ".xml";

    public static void initLogging(String location) throws FileNotFoundException {
        String resolvedLocation = SystemPropertyUtils.resolvePlaceholders(location);
        URL url = ResourceUtils.getURL(resolvedLocation);
        if ("file".equals(url.getProtocol()) && !ResourceUtils.getFile(url).exists()) {
            throw new FileNotFoundException("Log4j config file [" + resolvedLocation + "] not found");
        }
        if (resolvedLocation.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            DOMConfigurator.configure((URL)url);
        } else {
            PropertyConfigurator.configure((URL)url);
        }
    }

    public static void initLogging(String location, long refreshInterval) throws FileNotFoundException {
        String resolvedLocation = SystemPropertyUtils.resolvePlaceholders(location);
        File file2 = ResourceUtils.getFile(resolvedLocation);
        if (!file2.exists()) {
            throw new FileNotFoundException("Log4j config file [" + resolvedLocation + "] not found");
        }
        if (resolvedLocation.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            DOMConfigurator.configureAndWatch((String)file2.getAbsolutePath(), (long)refreshInterval);
        } else {
            PropertyConfigurator.configureAndWatch((String)file2.getAbsolutePath(), (long)refreshInterval);
        }
    }

    public static void shutdownLogging() {
        LogManager.shutdown();
    }

    public static void setWorkingDirSystemProperty(String key2) {
        System.setProperty(key2, new File("").getAbsolutePath());
    }
}

