/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.MultiValueMap;

public class LinkedMultiValueMap<K, V>
implements MultiValueMap<K, V>,
Serializable {
    private static final long serialVersionUID = 3801124242820219131L;
    private final Map<K, List<V>> targetMap;

    public LinkedMultiValueMap() {
        this.targetMap = new LinkedHashMap<K, List<V>>();
    }

    public LinkedMultiValueMap(int initialCapacity) {
        this.targetMap = new LinkedHashMap<K, List<V>>(initialCapacity);
    }

    public LinkedMultiValueMap(Map<K, List<V>> otherMap) {
        this.targetMap = new LinkedHashMap<K, List<List<V>>>(otherMap);
    }

    @Override
    public void add(K key2, V value) {
        List<V> values = this.targetMap.get(key2);
        if (values == null) {
            values = new LinkedList<V>();
            this.targetMap.put(key2, values);
        }
        values.add(value);
    }

    @Override
    public V getFirst(K key2) {
        List<V> values = this.targetMap.get(key2);
        return values != null ? (V)values.get(0) : null;
    }

    @Override
    public void set(K key2, V value) {
        LinkedList<V> values = new LinkedList<V>();
        values.add(value);
        this.targetMap.put(key2, values);
    }

    @Override
    public void setAll(Map<K, V> values) {
        for (Map.Entry<K, V> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<K, V> toSingleValueMap() {
        LinkedHashMap<K, V> singleValueMap = new LinkedHashMap<K, V>(this.targetMap.size());
        for (Map.Entry<K, List<V>> entry : this.targetMap.entrySet()) {
            singleValueMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.targetMap.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    @Override
    public List<V> get(Object key2) {
        return this.targetMap.get(key2);
    }

    @Override
    public List<V> put(K key2, List<V> value) {
        return this.targetMap.put(key2, value);
    }

    @Override
    public List<V> remove(Object key2) {
        return this.targetMap.remove(key2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> map2) {
        this.targetMap.putAll(map2);
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.targetMap.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.targetMap.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.targetMap.entrySet();
    }

    public LinkedMultiValueMap<K, V> clone() {
        return new LinkedMultiValueMap<K, V>(this);
    }

    public LinkedMultiValueMap<K, V> deepCopy() {
        LinkedMultiValueMap copy2 = new LinkedMultiValueMap(this.targetMap.size());
        for (Map.Entry<K, List<V>> entry : this.targetMap.entrySet()) {
            copy2.put(entry.getKey(), new LinkedList(entry.getValue()));
        }
        return copy2;
    }

    @Override
    public boolean equals(Object obj) {
        return this.targetMap.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

