/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

public abstract class CollectionUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map2) {
        return map2 == null || map2.isEmpty();
    }

    public static List arrayToList(Object source2) {
        return Arrays.asList(ObjectUtils.toObjectArray(source2));
    }

    public static <E> void mergeArrayIntoCollection(Object array2, Collection<E> collection) {
        Object[] arr;
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        for (Object elem : arr = ObjectUtils.toObjectArray(array2)) {
            collection.add(elem);
        }
    }

    public static <K, V> void mergePropertiesIntoMap(Properties props, Map<K, V> map2) {
        if (map2 == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key2 = (String)en.nextElement();
                Object value = props.getProperty(key2);
                if (value == null) {
                    value = props.get(key2);
                }
                map2.put(key2, (String)value);
            }
        }
    }

    public static boolean contains(Iterator<?> iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration<?> enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(Collection<?> collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection<?> source2, Collection<?> candidates) {
        if (CollectionUtils.isEmpty(source2) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        for (Object candidate : candidates) {
            if (!source2.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static <E> E findFirstMatch(Collection<?> source2, Collection<E> candidates) {
        if (CollectionUtils.isEmpty(source2) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (E candidate : candidates) {
            if (!source2.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static <T> T findValueOfType(Collection<?> collection, Class<T> type2) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        T value = null;
        for (Object element : collection) {
            if (type2 != null && !type2.isInstance(element)) continue;
            if (value != null) {
                return null;
            }
            value = (T)element;
        }
        return value;
    }

    public static Object findValueOfType(Collection<?> collection, Class<?>[] types) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types)) {
            return null;
        }
        for (Class<?> type2 : types) {
            Object value = CollectionUtils.findValueOfType(collection, type2);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static Class<?> findCommonElementType(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class<?> candidate = null;
        for (Object val2 : collection) {
            if (val2 == null) continue;
            if (candidate == null) {
                candidate = val2.getClass();
                continue;
            }
            if (candidate == val2.getClass()) continue;
            return null;
        }
        return candidate;
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] array2) {
        ArrayList<E> elements = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            elements.add(enumeration.nextElement());
        }
        return elements.toArray(array2);
    }

    public static <E> Iterator<E> toIterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    public static <K, V> MultiValueMap<K, V> toMultiValueMap(Map<K, List<V>> map2) {
        return new MultiValueMapAdapter<K, V>(map2);
    }

    public static <K, V> MultiValueMap<K, V> unmodifiableMultiValueMap(MultiValueMap<? extends K, ? extends V> map2) {
        Assert.notNull(map2, "'map' must not be null");
        LinkedHashMap result = new LinkedHashMap(map2.size());
        for (Map.Entry entry : map2.entrySet()) {
            List values = Collections.unmodifiableList((List)entry.getValue());
            result.put(entry.getKey(), values);
        }
        Map unmodifiableMap = Collections.unmodifiableMap(result);
        return CollectionUtils.toMultiValueMap(unmodifiableMap);
    }

    private static class MultiValueMapAdapter<K, V>
    implements MultiValueMap<K, V>,
    Serializable {
        private final Map<K, List<V>> map;

        public MultiValueMapAdapter(Map<K, List<V>> map2) {
            Assert.notNull(map2, "'map' must not be null");
            this.map = map2;
        }

        @Override
        public void add(K key2, V value) {
            List<V> values = this.map.get(key2);
            if (values == null) {
                values = new LinkedList<V>();
                this.map.put(key2, values);
            }
            values.add(value);
        }

        @Override
        public V getFirst(K key2) {
            List<V> values = this.map.get(key2);
            return values != null ? (V)values.get(0) : null;
        }

        @Override
        public void set(K key2, V value) {
            LinkedList<V> values = new LinkedList<V>();
            values.add(value);
            this.map.put(key2, values);
        }

        @Override
        public void setAll(Map<K, V> values) {
            for (Map.Entry<K, V> entry : values.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Map<K, V> toSingleValueMap() {
            LinkedHashMap<K, V> singleValueMap = new LinkedHashMap<K, V>(this.map.size());
            for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
                singleValueMap.put(entry.getKey(), entry.getValue().get(0));
            }
            return singleValueMap;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key2) {
            return this.map.containsKey(key2);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public List<V> get(Object key2) {
            return this.map.get(key2);
        }

        @Override
        public List<V> put(K key2, List<V> value) {
            return this.map.put(key2, value);
        }

        @Override
        public List<V> remove(Object key2) {
            return this.map.remove(key2);
        }

        @Override
        public void putAll(Map<? extends K, ? extends List<V>> map2) {
            this.map.putAll(map2);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<List<V>> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, List<V>>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return this.map.equals(other);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return this.map.toString();
        }
    }

    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private final Enumeration<E> enumeration;

        public EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

