/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxws;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.UsesSunHttpServer;
import org.springframework.remoting.jaxws.AbstractJaxWsServiceExporter;

@UsesSunHttpServer
public class SimpleHttpServerJaxWsServiceExporter
extends AbstractJaxWsServiceExporter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private HttpServer server;
    private int port = 8080;
    private String hostname;
    private int backlog = -1;
    private int shutdownDelay = 0;
    private String basePath = "/";
    private List<Filter> filters;
    private Authenticator authenticator;
    private boolean localServer = false;

    public void setServer(HttpServer server2) {
        this.server = server2;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setShutdownDelay(int shutdownDelay) {
        this.shutdownDelay = shutdownDelay;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.server == null) {
            InetSocketAddress address = this.hostname != null ? new InetSocketAddress(this.hostname, this.port) : new InetSocketAddress(this.port);
            this.server = HttpServer.create(address, this.backlog);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Starting HttpServer at address " + address);
            }
            this.server.start();
            this.localServer = true;
        }
        super.afterPropertiesSet();
    }

    @Override
    protected void publishEndpoint(Endpoint endpoint, WebService annotation) {
        endpoint.publish((Object)this.buildHttpContext(endpoint, annotation.serviceName()));
    }

    @Override
    protected void publishEndpoint(Endpoint endpoint, WebServiceProvider annotation) {
        endpoint.publish((Object)this.buildHttpContext(endpoint, annotation.serviceName()));
    }

    protected HttpContext buildHttpContext(Endpoint endpoint, String serviceName) {
        String fullPath = this.calculateEndpointPath(endpoint, serviceName);
        HttpContext httpContext = this.server.createContext(fullPath);
        if (this.filters != null) {
            httpContext.getFilters().addAll(this.filters);
        }
        if (this.authenticator != null) {
            httpContext.setAuthenticator(this.authenticator);
        }
        return httpContext;
    }

    protected String calculateEndpointPath(Endpoint endpoint, String serviceName) {
        return this.basePath + serviceName;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.localServer) {
            this.logger.info("Stopping HttpServer");
            this.server.stop(this.shutdownDelay);
        }
    }
}

