/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.springframework.core.env.PropertySource;
import org.springframework.jndi.JndiLocatorDelegate;

public class JndiPropertySource
extends PropertySource<JndiLocatorDelegate> {
    public JndiPropertySource(String name2) {
        this(name2, JndiLocatorDelegate.createDefaultResourceRefLocator());
    }

    public JndiPropertySource(String name2, JndiLocatorDelegate jndiLocator) {
        super(name2, jndiLocator);
    }

    @Override
    public Object getProperty(String name2) {
        try {
            Object value = ((JndiLocatorDelegate)this.source).lookup(name2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JNDI lookup for name [" + name2 + "] returned: [" + value + "]");
            }
            return value;
        }
        catch (NamingException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JNDI lookup for name [" + name2 + "] threw NamingException " + "with message: " + ex.getMessage() + ". Returning null.");
            }
            return null;
        }
    }
}

