/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class ShadowingClassLoader
extends DecoratingClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle.", "com.sun.", "com.ibm.", "COM.ibm.", "org.w3c.", "org.xml.", "org.dom4j.", "org.eclipse", "org.aspectj.", "net.sf.cglib", "org.springframework.cglib", "org.apache.xerces.", "org.apache.commons.logging."};
    private final ClassLoader enclosingClassLoader;
    private final List<ClassFileTransformer> classFileTransformers = new LinkedList<ClassFileTransformer>();
    private final Map<String, Class<?>> classCache = new HashMap();

    public ShadowingClassLoader(ClassLoader enclosingClassLoader) {
        Assert.notNull(enclosingClassLoader, "Enclosing ClassLoader must not be null");
        this.enclosingClassLoader = enclosingClassLoader;
        for (String excludedPackage : DEFAULT_EXCLUDED_PACKAGES) {
            this.excludePackage(excludedPackage);
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull(transformer, "Transformer must not be null");
        this.classFileTransformers.add(transformer);
    }

    public void copyTransformers(ShadowingClassLoader other) {
        Assert.notNull(other, "Other ClassLoader must not be null");
        this.classFileTransformers.addAll(other.classFileTransformers);
    }

    @Override
    public Class<?> loadClass(String name2) throws ClassNotFoundException {
        if (this.shouldShadow(name2)) {
            Class<?> cls = this.classCache.get(name2);
            if (cls != null) {
                return cls;
            }
            return this.doLoadClass(name2);
        }
        return this.enclosingClassLoader.loadClass(name2);
    }

    private boolean shouldShadow(String className) {
        return !className.equals(this.getClass().getName()) && !className.endsWith("ShadowingClassLoader") && this.isEligibleForShadowing(className);
    }

    protected boolean isEligibleForShadowing(String className) {
        return !this.isExcluded(className);
    }

    private Class<?> doLoadClass(String name2) throws ClassNotFoundException {
        String internalName = StringUtils.replace(name2, ".", "/") + ".class";
        InputStream is2 = this.enclosingClassLoader.getResourceAsStream(internalName);
        if (is2 == null) {
            throw new ClassNotFoundException(name2);
        }
        try {
            int packageSeparator;
            byte[] bytes2 = FileCopyUtils.copyToByteArray(is2);
            bytes2 = this.applyTransformers(name2, bytes2);
            Class<?> cls = this.defineClass(name2, bytes2, 0, bytes2.length);
            if (cls.getPackage() == null && (packageSeparator = name2.lastIndexOf(46)) != -1) {
                String packageName = name2.substring(0, packageSeparator);
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            this.classCache.put(name2, cls);
            return cls;
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name2 + "]", ex);
        }
    }

    private byte[] applyTransformers(String name2, byte[] bytes2) {
        String internalName = StringUtils.replace(name2, ".", "/");
        try {
            for (ClassFileTransformer transformer : this.classFileTransformers) {
                byte[] transformed = transformer.transform(this, internalName, null, null, bytes2);
                bytes2 = transformed != null ? transformed : bytes2;
            }
            return bytes2;
        }
        catch (IllegalClassFormatException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public URL getResource(String name2) {
        return this.enclosingClassLoader.getResource(name2);
    }

    @Override
    public InputStream getResourceAsStream(String name2) {
        return this.enclosingClassLoader.getResourceAsStream(name2);
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        return this.enclosingClassLoader.getResources(name2);
    }
}

