/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.support;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.format.Formatter;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.Assert;

public class FormatterPropertyEditorAdapter
extends PropertyEditorSupport {
    private final Formatter<Object> formatter;

    public FormatterPropertyEditorAdapter(Formatter<?> formatter2) {
        Assert.notNull(formatter2, "Formatter must not be null");
        this.formatter = formatter2;
    }

    public Class<?> getFieldType() {
        return FormattingConversionService.getFieldType(this.formatter);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setValue(this.formatter.parse(text, LocaleContextHolder.getLocale()));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Parse attempt failed for value [" + text + "]", ex);
        }
    }

    @Override
    public String getAsText() {
        return this.formatter.print(this.getValue(), LocaleContextHolder.getLocale());
    }
}

